/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.worldgen.featurecancellation;

import com.ferreusveritas.dynamictrees.api.worldgen.BiomePropertySelectors;
import com.ferreusveritas.dynamictrees.api.worldgen.FeatureCanceller;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomBooleanFeatureConfiguration;
import net.minecraftforge.registries.ForgeRegistries;

public class MushroomFeatureCanceller<T extends FeatureConfiguration>
extends FeatureCanceller {
    private final Class<T> mushroomFeatureConfigClass;

    public MushroomFeatureCanceller(ResourceLocation registryName, Class<T> mushroomFeatureConfigClass) {
        super(registryName);
        this.mushroomFeatureConfigClass = mushroomFeatureConfigClass;
    }

    @Override
    public boolean shouldCancel(ConfiguredFeature<?, ?> configuredFeature, BiomePropertySelectors.NormalFeatureCancellation featureCancellations) {
        ResourceLocation featureRegistryName = ForgeRegistries.FEATURES.getKey((Object)configuredFeature.f_65377_());
        if (featureRegistryName == null) {
            return false;
        }
        FeatureConfiguration featureConfiguration = configuredFeature.f_65378_();
        if (!(featureConfiguration instanceof RandomBooleanFeatureConfiguration)) {
            return false;
        }
        RandomBooleanFeatureConfiguration randomBooleanFeatureConfiguration = (RandomBooleanFeatureConfiguration)featureConfiguration;
        return this.getConfigs(randomBooleanFeatureConfiguration).anyMatch(this.mushroomFeatureConfigClass::isInstance) && featureCancellations.shouldCancelNamespace(featureRegistryName.m_135827_());
    }

    private Stream<FeatureConfiguration> getConfigs(RandomBooleanFeatureConfiguration twoFeatureConfig) {
        return twoFeatureConfig.m_7817_().map(ConfiguredFeature::f_65378_);
    }
}

