/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.worldgen.structure;

import com.ferreusveritas.dynamictrees.DynamicTrees;
import com.ferreusveritas.dynamictrees.init.DTTrees;
import com.ferreusveritas.dynamictrees.tree.species.Species;
import com.ferreusveritas.dynamictrees.worldgen.structure.RegularTemplatePoolModifier;
import com.ferreusveritas.dynamictrees.worldgen.structure.TreePoolElement;
import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.data.worldgen.PlainVillagePools;
import net.minecraft.data.worldgen.ProcessorLists;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.levelgen.structure.pools.ListPoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class VillageTreeReplacement {
    public static final Logger LOGGER = LogManager.getLogger();
    private static final String REPLACEMENT_TOWN_CENTER_ID = DynamicTrees.location("village/plains/town_centers/plains_meeting_point_3").toString();

    public static void replaceTreesFromVanillaVillages(HolderLookup.Provider vanillaProvider, BootstapContext<StructureTemplatePool> context) {
        HolderLookup.RegistryLookup processorLists = vanillaProvider.m_255025_(Registries.f_257011_);
        TreePoolElement townCenterTreePattern = new TreePoolElement((Species)Species.REGISTRY.get(DTTrees.OAK), new BlockPos(5, 1, 5), StructureTemplatePool.Projection.RIGID);
        RegularTemplatePoolModifier.create(vanillaProvider, (ResourceKey<StructureTemplatePool>)PlainVillagePools.f_127183_).replaceTemplate(3, (StructurePoolElement)new ListPoolElement((List)ImmutableList.of((Object)((StructurePoolElement)StructurePoolElement.m_210512_((String)REPLACEMENT_TOWN_CENTER_ID, (Holder)processorLists.m_255043_(ProcessorLists.f_127206_)).apply(StructureTemplatePool.Projection.RIGID)), (Object)((Object)townCenterTreePattern)), StructureTemplatePool.Projection.RIGID)).replaceTemplate(7, (StructurePoolElement)new ListPoolElement((List)ImmutableList.of((Object)((StructurePoolElement)StructurePoolElement.m_210512_((String)REPLACEMENT_TOWN_CENTER_ID, (Holder)processorLists.m_255043_(ProcessorLists.f_127199_)).apply(StructureTemplatePool.Projection.RIGID)), (Object)((Object)townCenterTreePattern)), StructureTemplatePool.Projection.RIGID)).registerPool(context);
        TreePoolElement oakTreePattern = new TreePoolElement((Species)Species.REGISTRY.get(DTTrees.OAK), StructureTemplatePool.Projection.TERRAIN_MATCHING);
        RegularTemplatePoolModifier.village(vanillaProvider, "plains", "trees").replaceTemplate(0, oakTreePattern).registerPool(context);
        RegularTemplatePoolModifier.village(vanillaProvider, "plains", "decor").replaceTemplate(1, oakTreePattern).registerPool(context);
        RegularTemplatePoolModifier.village(vanillaProvider, "plains", "zombie/decor").replaceTemplate(1, oakTreePattern).registerPool(context);
        TreePoolElement acaciaTreePattern = new TreePoolElement((Species)Species.REGISTRY.get(DTTrees.ACACIA), StructureTemplatePool.Projection.TERRAIN_MATCHING);
        RegularTemplatePoolModifier.village(vanillaProvider, "savanna", "trees").replaceTemplate(0, acaciaTreePattern).registerPool(context);
        RegularTemplatePoolModifier.village(vanillaProvider, "savanna", "decor").replaceTemplate(1, acaciaTreePattern).registerPool(context);
        RegularTemplatePoolModifier.village(vanillaProvider, "savanna", "zombie/decor").replaceTemplate(1, acaciaTreePattern).registerPool(context);
        TreePoolElement spruceTreePattern = new TreePoolElement((Species)Species.REGISTRY.get(DTTrees.SPRUCE), StructureTemplatePool.Projection.TERRAIN_MATCHING);
        RegularTemplatePoolModifier.village(vanillaProvider, "snowy", "trees").replaceTemplate(0, spruceTreePattern).registerPool(context);
        RegularTemplatePoolModifier.village(vanillaProvider, "snowy", "decor").replaceTemplate(3, spruceTreePattern).registerPool(context);
        RegularTemplatePoolModifier.village(vanillaProvider, "snowy", "zombie/decor").replaceTemplate(3, spruceTreePattern).registerPool(context);
        RegularTemplatePoolModifier.village(vanillaProvider, "taiga", "decor").replaceTemplate(7, spruceTreePattern).replaceTemplate(8, spruceTreePattern).registerPool(context);
        RegularTemplatePoolModifier.village(vanillaProvider, "taiga", "zombie/decor").replaceTemplate(4, spruceTreePattern).replaceTemplate(5, spruceTreePattern).registerPool(context);
    }
}

