/*
 * Decompiled with CFR 0.152.
 */
package satisfy.beachparty.compat.jei.categorys;

import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.block.Block;
import satisfy.beachparty.client.gui.TikiBarGui;
import satisfy.beachparty.compat.jei.BeachpartyJEIPlugin;
import satisfy.beachparty.recipe.TikiBarRecipe;
import satisfy.beachparty.registry.ObjectRegistry;

public class TikiBarCategory
implements IRecipeCategory<TikiBarRecipe> {
    public static final RecipeType<TikiBarRecipe> TIKI_BAR = RecipeType.create((String)"beachparty", (String)"tiki_bar_mixing", TikiBarRecipe.class);
    public static final int WIDTH = 124;
    public static final int HEIGHT = 60;
    public static final int WIDTH_OF = 26;
    public static final int HEIGHT_OF = 13;
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawableAnimated arrow;
    private final IDrawableAnimated shake;
    private final Component localizedName;

    public TikiBarCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(TikiBarGui.BG, 26, 13, 124, 60);
        this.arrow = helper.drawableBuilder(TikiBarGui.BG, 177, 26, 22, 10).buildAnimated(50, IDrawableAnimated.StartDirection.LEFT, false);
        this.shake = helper.drawableBuilder(TikiBarGui.BG, 179, 2, 15, 20).buildAnimated(50, IDrawableAnimated.StartDirection.BOTTOM, false);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)((Block)ObjectRegistry.TIKI_BAR.get()).m_5456_().m_7968_());
        this.localizedName = Component.m_237115_((String)"rei.beachparty.tiki_bar_category");
    }

    public void draw(TikiBarRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.arrow.draw(guiGraphics, 68, 32);
        this.shake.draw(guiGraphics, 70, 9);
    }

    public RecipeType<TikiBarRecipe> getRecipeType() {
        return TIKI_BAR;
    }

    public Component getTitle() {
        return this.localizedName;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, TikiBarRecipe recipe, IFocusGroup focuses) {
        NonNullList<Ingredient> ingredients = recipe.m_7527_();
        int s = ingredients.size();
        if (s > 0) {
            BeachpartyJEIPlugin.addSlot(builder, 29, 13, (Ingredient)ingredients.get(0));
        }
        if (s > 1) {
            BeachpartyJEIPlugin.addSlot(builder, 29, 31, (Ingredient)ingredients.get(1));
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, 102, 22).addItemStack(recipe.m_8043_(Minecraft.m_91087_().f_91073_.m_9598_()));
    }
}

