/*
 * Decompiled with CFR 0.152.
 */
package com.copycatsplus.copycats.content.copycat.vertical_step;

import com.copycatsplus.copycats.CCBlocks;
import com.copycatsplus.copycats.CCShapes;
import com.copycatsplus.copycats.foundation.copycat.CCWaterloggedCopycatBlock;
import com.copycatsplus.copycats.foundation.copycat.ICopycatBlock;
import com.copycatsplus.copycats.foundation.copycat.IStateType;
import com.copycatsplus.copycats.utility.BlockUtils;
import com.copycatsplus.copycats.utility.InteractionUtils;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.contraptions.StructureTransform;
import com.simibubi.create.foundation.placement.IPlacementHelper;
import com.simibubi.create.foundation.placement.PlacementHelpers;
import com.simibubi.create.foundation.placement.PoleHelper;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.Pair;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class CopycatVerticalStepBlock
extends CCWaterloggedCopycatBlock
implements IStateType {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    private static final int placementHelperId = PlacementHelpers.register((IPlacementHelper)new PlacementHelper());
    private static final Map<Pair<Integer, Integer>, Direction> VERTICAL_POSITION_MAP = new HashMap<Pair<Integer, Integer>, Direction>();
    private static final Map<Pair<Direction, Integer>, Direction> HORIZONTAL_POSITION_MAP = new HashMap<Pair<Direction, Integer>, Direction>();

    public CopycatVerticalStepBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    @Override
    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState state, @NotNull Level world, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult ray) {
        return InteractionUtils.sequential(() -> InteractionUtils.usePlacementHelper(placementHelperId, state, world, pos, player, hand, ray), () -> super.m_6227_(state, world, pos, player, hand, ray));
    }

    @Override
    public boolean isIgnoredConnectivitySide(BlockAndTintGetter reader, BlockState state, Direction face, BlockPos fromPos, BlockPos toPos) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        BlockState toState = reader.m_8055_(toPos);
        if (toState.m_60713_((Block)this)) {
            return toState.m_61143_((Property)FACING) != direction;
        }
        return true;
    }

    @Override
    public boolean canConnectTexturesToward(BlockAndTintGetter reader, BlockPos fromPos, BlockPos toPos, BlockState state) {
        BlockState toState = reader.m_8055_(toPos);
        if (!toState.m_60713_((Block)this)) {
            return false;
        }
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        BlockPos diff = toPos.m_121996_((Vec3i)fromPos);
        if (diff.equals((Object)Vec3i.f_123288_)) {
            return true;
        }
        Direction face = Direction.m_122378_((int)diff.m_123341_(), (int)diff.m_123342_(), (int)diff.m_123343_());
        if (face == null) {
            return false;
        }
        if (toState.m_60713_((Block)this)) {
            try {
                return toState.m_61143_((Property)FACING) == facing && face.m_122434_() == Direction.Axis.Y;
            }
            catch (IllegalStateException ignored) {
                return false;
            }
        }
        return false;
    }

    public boolean m_7357_(@NotNull BlockState pState, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos, @NotNull PathComputationType pType) {
        return false;
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext context) {
        int zOffset;
        BlockState stateForPlacement = super.m_5573_(context);
        if (stateForPlacement == null) {
            return null;
        }
        int xOffset = context.m_43720_().f_82479_ - (double)context.m_8083_().m_123341_() > 0.5 ? 1 : -1;
        int n = zOffset = context.m_43720_().f_82481_ - (double)context.m_8083_().m_123343_() > 0.5 ? 1 : -1;
        if (context.m_43719_().m_122434_() == Direction.Axis.Y) {
            return (BlockState)stateForPlacement.m_61124_((Property)FACING, (Comparable)VERTICAL_POSITION_MAP.get(Pair.of((Object)xOffset, (Object)zOffset)));
        }
        return (BlockState)stateForPlacement.m_61124_((Property)FACING, (Comparable)HORIZONTAL_POSITION_MAP.get(Pair.of((Object)context.m_43719_(), (Object)(context.m_43719_().m_122434_() == Direction.Axis.X ? zOffset : xOffset))));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.m_7926_((StateDefinition.Builder<Block, BlockState>)pBuilder.m_61104_(new Property[]{FACING}));
    }

    @NotNull
    public VoxelShape m_5940_(BlockState pState, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos, @NotNull CollisionContext pContext) {
        return CCShapes.VERTICAL_STEP.get(pState.m_61143_((Property)FACING)).toShape();
    }

    public boolean supportsExternalFaceHiding(BlockState state) {
        return true;
    }

    @Override
    public boolean hidesNeighborFace(BlockGetter level, BlockPos pos, BlockState state, BlockState neighborState, Direction dir) {
        return ICopycatBlock.hidesNeighborFace(level, pos, state, neighborState, dir);
    }

    @Override
    public BlockState transform(BlockState state, StructureTransform transform) {
        return BlockUtils.transformStepLikeVertical(state, transform, AllBlocks.COPYCAT_STEP.getDefaultState());
    }

    static {
        for (Direction main : Iterate.horizontalDirections) {
            Direction cross = main.m_122428_();
            int mainOffset = main.m_122421_().m_122540_();
            int crossOffset = cross.m_122421_().m_122540_();
            if (main.m_122434_() == Direction.Axis.X) {
                VERTICAL_POSITION_MAP.put((Pair<Integer, Integer>)Pair.of((Object)mainOffset, (Object)crossOffset), main);
            } else {
                VERTICAL_POSITION_MAP.put((Pair<Integer, Integer>)Pair.of((Object)crossOffset, (Object)mainOffset), main);
            }
            HORIZONTAL_POSITION_MAP.put((Pair<Direction, Integer>)Pair.of((Object)main.m_122424_(), (Object)crossOffset), main);
            HORIZONTAL_POSITION_MAP.put((Pair<Direction, Integer>)Pair.of((Object)cross.m_122424_(), (Object)mainOffset), main);
        }
    }

    @MethodsReturnNonnullByDefault
    private static class PlacementHelper
    extends PoleHelper<Direction> {
        private PlacementHelper() {
            super(arg_0 -> CCBlocks.COPYCAT_VERTICAL_STEP.has(arg_0), $ -> Direction.Axis.Y, (Property)FACING);
        }

        public Predicate<ItemStack> getItemPredicate() {
            return i -> i.m_41720_() instanceof BlockItem && ((BlockItem)i.m_41720_()).m_40614_() instanceof CopycatVerticalStepBlock;
        }
    }
}

