/*
 * Decompiled with CFR 0.152.
 */
package com.copycatsplus.copycats.foundation.copycat.multistate;

import com.copycatsplus.copycats.CCKeys;
import com.copycatsplus.copycats.compat.AthenaCompat;
import com.copycatsplus.copycats.compat.Mods;
import com.copycatsplus.copycats.foundation.copycat.ICopycatBlock;
import com.copycatsplus.copycats.foundation.copycat.IStateType;
import com.copycatsplus.copycats.foundation.copycat.StateType;
import com.copycatsplus.copycats.foundation.copycat.model.ScaledBlockAndTintGetter;
import com.copycatsplus.copycats.foundation.copycat.multistate.IMultiStateCopycatBlockEntity;
import com.copycatsplus.copycats.foundation.copycat.multistate.MaterialItemStorage;
import com.copycatsplus.copycats.foundation.copycat.multistate.MultiStateRenderManager;
import com.copycatsplus.copycats.network.CCPackets;
import com.copycatsplus.copycats.network.FillCopycatPacket;
import com.copycatsplus.copycats.utility.BlockEntityUtils;
import com.copycatsplus.copycats.utility.BlockFaceUtils;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.AllTags;
import com.simibubi.create.content.contraptions.StructureTransform;
import com.simibubi.create.content.equipment.wrench.WrenchItem;
import com.simibubi.create.content.schematics.requirement.ItemRequirement;
import java.util.Optional;
import java.util.Set;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GrassColor;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public interface IMultiStateCopycatBlock
extends ICopycatBlock,
IStateType {
    @Override
    default public StateType stateType() {
        return StateType.MULTI;
    }

    @Override
    @Nullable
    default public IMultiStateCopycatBlockEntity getCopycatBlockEntity(BlockGetter worldIn, BlockPos pos) {
        BlockEntity blockEntity = worldIn.m_7702_(pos);
        if (blockEntity == null) {
            return null;
        }
        if (!(blockEntity instanceof IMultiStateCopycatBlockEntity)) {
            return null;
        }
        IMultiStateCopycatBlockEntity copycatBE = (IMultiStateCopycatBlockEntity)blockEntity;
        return copycatBE;
    }

    public String defaultProperty();

    public Vec3i vectorScale(BlockState var1);

    public Set<String> storageProperties();

    public int getColorIndex(String var1);

    public boolean partExists(BlockState var1, String var2);

    public Vec3i getVectorFromProperty(BlockState var1, String var2);

    public String getPropertyFromInteraction(BlockState var1, BlockGetter var2, Vec3i var3, BlockPos var4, Direction var5, Vec3 var6);

    default public String getPropertyFromInteraction(BlockState state, BlockGetter level, BlockPos pos, Vec3 hitVec, Direction face, boolean targetingSolid) {
        hitVec = targetingSolid ? hitVec.m_82546_(Vec3.m_82528_((Vec3i)face.m_122436_()).m_82490_(0.05)) : hitVec.m_82549_(Vec3.m_82528_((Vec3i)face.m_122436_()).m_82490_(0.05));
        Vec3 unscaledHit = hitVec = hitVec.m_82520_((double)(-pos.m_123341_()), (double)(-pos.m_123342_()), (double)(-pos.m_123343_()));
        Vec3i scale = this.vectorScale(state);
        hitVec = hitVec.m_82542_((double)scale.m_123341_(), (double)scale.m_123342_(), (double)scale.m_123343_());
        BlockPos location = new BlockPos((int)hitVec.m_7096_(), (int)hitVec.m_7098_(), (int)hitVec.m_7094_());
        return this.getPropertyFromInteraction(state, level, (Vec3i)location, pos, face, unscaledHit);
    }

    default public String getPropertyFromInteraction(BlockState state, BlockGetter level, BlockPos pos, BlockHitResult hit, boolean targetingSolid) {
        Vec3 hitVec = hit.m_82450_();
        return this.getPropertyFromInteraction(state, level, pos, hitVec, hit.m_82434_(), targetingSolid);
    }

    default public String getPropertyFromRender(String renderingProperty, BlockState state, ScaledBlockAndTintGetter level, Vec3i vector, BlockPos blockPos) {
        Vec3i scale = this.vectorScale(state);
        return this.getPropertyFromInteraction(state, (BlockGetter)level, vector, blockPos, Direction.UP, Vec3.m_82528_((Vec3i)vector).m_82542_(1.0 / (double)scale.m_123341_(), 1.0 / (double)scale.m_123342_(), 1.0 / (double)scale.m_123343_()));
    }

    @Override
    default public InteractionResult toggleCT(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (player.m_6144_() && player.m_21120_(hand).equals(ItemStack.f_41583_)) {
            if (!this.canToggleCT(state, (BlockAndTintGetter)level, pos)) {
                return InteractionResult.PASS;
            }
            String property = this.getPropertyFromInteraction(state, (BlockGetter)level, pos, hit, true);
            IMultiStateCopycatBlockEntity be = this.getCopycatBlockEntity((BlockGetter)level, pos);
            if (be == null) {
                return InteractionResult.PASS;
            }
            be.setEnableCT(property, !be.getMaterialItemStorage().getMaterialItem(property).enableCT());
            BlockEntityUtils.redraw((BlockEntity)be);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Override
    default public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        IMultiStateCopycatBlockEntity copycatBE = this.getCopycatBlockEntity((BlockGetter)context.m_43725_(), context.m_8083_());
        if (copycatBE == null) {
            return InteractionResult.PASS;
        }
        String property = this.getPropertyFromInteraction(state, (BlockGetter)context.m_43725_(), context.m_8083_(), context.m_43720_(), context.m_43719_(), true);
        if (!this.partExists(state, property)) {
            return InteractionResult.PASS;
        }
        MaterialItemStorage.MaterialItem material = copycatBE.getMaterialItemStorage().getMaterialItem(property);
        ItemStack consumedItem = material.consumedItem();
        if (!consumedItem.m_41619_()) {
            for (String prop : copycatBE.getMaterialItemStorage().getAllProperties()) {
                MaterialItemStorage.MaterialItem materialItem;
                if (prop.equals(property) || !(materialItem = copycatBE.getMaterialItemStorage().getMaterialItem(prop)).material().m_60734_().equals(material.material().m_60734_()) || !materialItem.consumedItem().m_41619_()) continue;
                copycatBE.setConsumedItem(prop, consumedItem);
                consumedItem = ItemStack.f_41583_;
                break;
            }
        }
        if (!copycatBE.getMaterialItemStorage().hasCustomMaterial(property)) {
            return InteractionResult.PASS;
        }
        Player player = context.m_43723_();
        if (!player.m_7500_()) {
            player.m_150109_().m_150079_(consumedItem);
        }
        context.m_43725_().m_46796_(2001, context.m_8083_(), Block.m_49956_((BlockState)material.material()));
        copycatBE.setMaterial(property, AllBlocks.COPYCAT_BASE.getDefaultState());
        copycatBE.setConsumedItem(property, ItemStack.f_41583_);
        return InteractionResult.SUCCESS;
    }

    @Nullable
    default public BlockState getAcceptedBlockState(String property, Level pLevel, BlockPos pPos, ItemStack item, Direction face) {
        return this.getAcceptedBlockState(pLevel, pPos, item, face);
    }

    @Override
    default public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        InteractionResult result;
        if (player.m_21120_(hand).m_204117_(AllTags.AllItemTags.WRENCH.tag) && (result = ((WrenchItem)AllItems.WRENCH.get()).m_6225_(new UseOnContext(player, hand, hit))).m_19077_()) {
            return result;
        }
        result = this.toggleCT(state, level, pos, player, hand, hit);
        if (result.m_19077_()) {
            return result;
        }
        if (player == null || !player.m_36326_()) {
            return InteractionResult.PASS;
        }
        String property = this.getPropertyFromInteraction(state, (BlockGetter)level, pos, hit, true);
        Direction face = hit.m_82434_();
        ItemStack itemInHand = player.m_21120_(hand);
        BlockState material = this.getAcceptedBlockState(property, level, pos, itemInHand, face);
        if (material != null) {
            material = this.prepareMaterial(level, pos, state, player, hand, hit, material);
        }
        if (material == null) {
            return InteractionResult.PASS;
        }
        IMultiStateCopycatBlockEntity copycatBE = this.getCopycatBlockEntity((BlockGetter)level, pos);
        if (copycatBE == null) {
            return InteractionResult.PASS;
        }
        if (!this.partExists(state, property)) {
            return InteractionResult.PASS;
        }
        if (copycatBE.getMaterialItemStorage().getMaterialItem(property).material().m_60713_(material.m_60734_())) {
            if (!copycatBE.cycleMaterial(property)) {
                return InteractionResult.PASS;
            }
            copycatBE.m_58904_().m_5594_(null, copycatBE.m_58899_(), SoundEvents.f_12013_, SoundSource.BLOCKS, 0.75f, 0.95f);
            return InteractionResult.SUCCESS;
        }
        if (copycatBE.getMaterialItemStorage().hasCustomMaterial(property)) {
            return InteractionResult.PASS;
        }
        if (level.m_5776_()) {
            if (CCKeys.FILL_COPYCAT.isPressed()) {
                this.fillEmptyParts(level, pos, state, material);
                CCPackets.PACKETS.send(new FillCopycatPacket(pos, material, property));
            }
            return InteractionResult.SUCCESS;
        }
        boolean freeToApply = copycatBE.getMaterialItemStorage().getAllConsumedItems().stream().anyMatch(s -> s.m_41720_() == itemInHand.m_41720_());
        copycatBE.setMaterial(property, material);
        if (!freeToApply) {
            copycatBE.setConsumedItem(property, itemInHand);
        }
        copycatBE.m_58904_().m_5594_(null, copycatBE.m_58899_(), material.m_60827_().m_56777_(), SoundSource.BLOCKS, 1.0f, 0.75f);
        if (player.m_7500_()) {
            return InteractionResult.SUCCESS;
        }
        if (!freeToApply) {
            itemInHand.m_41774_(1);
        }
        if (itemInHand.m_41619_()) {
            player.m_21008_(hand, ItemStack.f_41583_);
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    default public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        if (placer == null) {
            return;
        }
        ItemStack offhandItem = placer.m_21120_(InteractionHand.OFF_HAND);
        BlockState appliedState = this.getAcceptedBlockState(level, pos, offhandItem, Direction.m_122382_((Entity)placer)[0]);
        if (appliedState == null) {
            return;
        }
        IMultiStateCopycatBlockEntity copycatBE = this.getCopycatBlockEntity((BlockGetter)level, pos);
        if (copycatBE == null) {
            return;
        }
        for (String property : this.storageProperties()) {
            Player player;
            if (!this.partExists(state, property) || copycatBE.getMaterialItemStorage().hasCustomMaterial(property)) continue;
            boolean freeToApply = copycatBE.getMaterialItemStorage().getAllConsumedItems().stream().anyMatch(s -> s.m_41720_() == offhandItem.m_41720_());
            copycatBE.setMaterial(property, appliedState);
            if (!freeToApply) {
                copycatBE.setConsumedItem(property, offhandItem);
            }
            if (placer instanceof Player && (player = (Player)placer).m_7500_()) continue;
            if (!freeToApply) {
                offhandItem.m_41774_(1);
            }
            if (!offhandItem.m_41619_()) continue;
            placer.m_21008_(InteractionHand.OFF_HAND, ItemStack.f_41583_);
            break;
        }
    }

    @Override
    default public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving, ICopycatBlock.OnRemoveHandler handler) {
        IMultiStateCopycatBlockEntity copycatBE;
        if (!state.m_155947_() || state.m_60734_() == newState.m_60734_()) {
            return;
        }
        if (!isMoving && (copycatBE = this.getCopycatBlockEntity((BlockGetter)level, pos)) != null) {
            copycatBE.getMaterialItemStorage().getAllConsumedItems().forEach(stack -> Block.m_49840_((Level)level, (BlockPos)pos, (ItemStack)stack));
        }
        handler.handle(state, level, pos, newState, isMoving);
        level.m_46747_(pos);
    }

    @Override
    default public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        IMultiStateCopycatBlockEntity copycatBE;
        if (player.m_7500_() && (copycatBE = this.getCopycatBlockEntity((BlockGetter)level, pos)) != null) {
            copycatBE.getMaterialItemStorage().getAllProperties().forEach(key -> copycatBE.getMaterialItemStorage().getMaterialItem((String)key).setConsumedItem(ItemStack.f_41583_));
        }
    }

    default public void fillEmptyParts(Level level, BlockPos pos, BlockState state, BlockState material) {
        IMultiStateCopycatBlockEntity copycatBE = this.getCopycatBlockEntity((BlockGetter)level, pos);
        if (copycatBE == null) {
            return;
        }
        for (String property : copycatBE.getMaterialItemStorage().getAllProperties()) {
            if (copycatBE.getMaterialItemStorage().hasCustomMaterial(property) || !this.partExists(state, property)) continue;
            copycatBE.setMaterial(property, material);
        }
    }

    @Nullable
    public static VoxelShape blockShapeOverride(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        if (pLevel instanceof ScaledBlockAndTintGetter) {
            return Shapes.m_83144_();
        }
        return null;
    }

    public static BlockState getAppearance(IMultiStateCopycatBlock block, BlockState state, BlockAndTintGetter level, BlockPos pos, Direction side, BlockState queryState, BlockPos queryPos) {
        String property;
        BlockAndTintGetter reader = Mods.ATHENA.runIfInstalled(() -> () -> AthenaCompat.unwrapAthenaGetter(level)).orElse(level);
        if (reader instanceof ScaledBlockAndTintGetter) {
            ScaledBlockAndTintGetter scaledLevel = (ScaledBlockAndTintGetter)reader;
            property = scaledLevel.getPropertyForRender(state, pos);
        } else {
            property = block.defaultProperty();
        }
        IMultiStateCopycatBlockEntity be = block.getCopycatBlockEntity((BlockGetter)reader, queryPos);
        if (block.isIgnoredConnectivitySide(property, reader, state, side, pos, queryPos)) {
            return state;
        }
        BlockState material = IMultiStateCopycatBlock.getMaterial((BlockGetter)reader, pos, property);
        return material.m_60713_(Blocks.f_50016_) ? AllBlocks.COPYCAT_BASE.getDefaultState() : material;
    }

    public static BlockState getMaterial(BlockGetter reader, BlockPos targetPos, String property) {
        IMultiStateCopycatBlockEntity cbe;
        BlockEntity blockEntity = reader.m_7702_(targetPos);
        if (blockEntity instanceof IMultiStateCopycatBlockEntity && (cbe = (IMultiStateCopycatBlockEntity)blockEntity).getMaterialItemStorage().getMaterialItem(property) != null) {
            return cbe.getMaterialItemStorage().getMaterialItem(property).material();
        }
        return Blocks.f_50016_.m_49966_();
    }

    public void transformStorage(BlockState var1, IMultiStateCopycatBlockEntity var2, StructureTransform var3);

    public static ItemRequirement getRequiredItemsForParts(BlockState state, BooleanProperty ... property) {
        int count = 0;
        for (BooleanProperty part : property) {
            if (!((Boolean)state.m_61143_((Property)part)).booleanValue()) continue;
            ++count;
        }
        if (count == 0) {
            return ItemRequirement.NONE;
        }
        return new ItemRequirement(IntStream.range(0, count).mapToObj($ -> new ItemRequirement.StackRequirement(new ItemStack((ItemLike)state.m_60734_().m_5456_()), ItemRequirement.ItemUseType.CONSUME)).toList());
    }

    @Override
    default public boolean isIgnoredConnectivitySide(BlockAndTintGetter reader, BlockState state, Direction face, BlockPos fromPos, BlockPos toPos) {
        return this.isIgnoredConnectivitySide(this.defaultProperty(), reader, state, face, fromPos, toPos);
    }

    @Override
    default public boolean canConnectTexturesToward(BlockAndTintGetter reader, BlockPos fromPos, BlockPos toPos, BlockState state) {
        return this.canConnectTexturesToward(this.defaultProperty(), reader, fromPos, toPos, state);
    }

    public boolean isIgnoredConnectivitySide(String var1, BlockAndTintGetter var2, BlockState var3, Direction var4, BlockPos var5, BlockPos var6);

    public boolean canConnectTexturesToward(String var1, BlockAndTintGetter var2, BlockPos var3, BlockPos var4, BlockState var5);

    @Override
    default public boolean canOcclude(BlockGetter level, BlockState state, BlockPos pos) {
        if (level instanceof ScaledBlockAndTintGetter) {
            ScaledBlockAndTintGetter scaledWorld = (ScaledBlockAndTintGetter)level;
            return this.canOcclude(scaledWorld.getPropertyForRender(state, pos), level, state, pos);
        }
        return false;
    }

    default public boolean canOcclude(String property, BlockGetter level, BlockState state, BlockPos pos) {
        BlockState material = IMultiStateCopycatBlock.getMaterial(level, pos, property);
        if (AllBlocks.COPYCAT_BASE.has(material)) {
            return false;
        }
        return material.m_60815_();
    }

    @Override
    default public Optional<Boolean> shapeCanOccludeNeighbor(BlockGetter level, BlockPos pos, BlockState state, BlockPos neighborPos, Direction dir) {
        BlockState neighborState = level.m_8055_(neighborPos);
        return Optional.of(BlockFaceUtils.canOcclude(level, neighborState, neighborPos, state, pos, dir.m_122424_()));
    }

    public static boolean hidesNeighborFace(BlockGetter level, BlockPos pos, BlockState state, BlockState neighborState, Direction dir) {
        BlockState neighborMaterial;
        BlockPos toPos = pos.m_121945_(dir);
        if (!(level instanceof ScaledBlockAndTintGetter)) {
            return false;
        }
        ScaledBlockAndTintGetter scaledWorld = (ScaledBlockAndTintGetter)level;
        BlockState material = state.m_60734_() instanceof IMultiStateCopycatBlock ? IMultiStateCopycatBlock.getMaterial(level, pos, scaledWorld.getPropertyForRender(state, pos)) : state;
        BlockState blockState = neighborMaterial = neighborState.m_60734_() instanceof IMultiStateCopycatBlock ? IMultiStateCopycatBlock.getMaterial(level, toPos, scaledWorld.getPropertyForRender(neighborState, toPos)) : neighborState;
        if (material.m_60719_(neighborMaterial, dir.m_122424_())) {
            return BlockFaceUtils.canOcclude(level, neighborState, toPos, state, pos, dir.m_122424_());
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static BlockColor wrappedColor() {
        return new WrappedBlockColor();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class WrappedBlockColor
    implements BlockColor {
        public int m_92566_(BlockState pState, @Nullable BlockAndTintGetter pLevel, @Nullable BlockPos pPos, int pTintIndex) {
            if (pLevel == null || pPos == null) {
                return GrassColor.m_46415_((double)0.5, (double)1.0);
            }
            String renderingProperty = MultiStateRenderManager.getRenderingProperty();
            if (renderingProperty != null) {
                return Minecraft.m_91087_().m_91298_().m_92577_(IMultiStateCopycatBlock.getMaterial((BlockGetter)pLevel, pPos, renderingProperty), pLevel, pPos, pTintIndex);
            }
            int tint = Minecraft.m_91087_().m_91298_().m_92577_(ICopycatBlock.getMaterial((BlockGetter)pLevel, pPos), pLevel, pPos, pTintIndex);
            BlockEntity be = pLevel.m_7702_(pPos);
            if (tint == -1 && be instanceof IMultiStateCopycatBlockEntity) {
                IMultiStateCopycatBlockEntity mscb = (IMultiStateCopycatBlockEntity)be;
                for (String property : mscb.getMaterialItemStorage().getAllProperties()) {
                    int anyTint = Minecraft.m_91087_().m_91298_().m_92577_(IMultiStateCopycatBlock.getMaterial((BlockGetter)pLevel, pPos, property), pLevel, pPos, pTintIndex);
                    if (anyTint == -1) continue;
                    return anyTint;
                }
            }
            return tint;
        }
    }
}

