/*
 * Decompiled with CFR 0.152.
 */
package com.agricraft.agricraft.api.codecs;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;

public record AgriSoilVariant(ExtraCodecs.TagOrElementLocation block, List<String> states) {
    public static final Codec<AgriSoilVariant> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.f_216161_.fieldOf("block").forGetter(variant -> variant.block), (App)Codec.STRING.listOf().comapFlatMap(AgriSoilVariant::readStates, list -> list).optionalFieldOf("states").forGetter(variant -> variant.states.isEmpty() ? Optional.empty() : Optional.of(variant.states))).apply((Applicative)instance, AgriSoilVariant::new));

    public AgriSoilVariant(ExtraCodecs.TagOrElementLocation block, Optional<List<String>> states) {
        this(block, states.orElse(List.of()));
    }

    private static DataResult<List<String>> readStates(List<String> states) {
        for (String state : states) {
            if (state.contains("=") && state.charAt(0) != '=' && state.charAt(state.length() - 1) != '=') continue;
            return DataResult.error(() -> "invalid state definition");
        }
        return DataResult.success(states);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        ExtraCodecs.TagOrElementLocation block = new ExtraCodecs.TagOrElementLocation(new ResourceLocation("minecraft", "air"), false);
        List<String> states = new ArrayList<String>();

        public AgriSoilVariant build() {
            return new AgriSoilVariant(this.block, this.states);
        }

        public Builder block(String location) {
            this.block = new ExtraCodecs.TagOrElementLocation(new ResourceLocation(location), false);
            return this;
        }

        public Builder block(String namespace, String path) {
            this.block = new ExtraCodecs.TagOrElementLocation(new ResourceLocation(namespace, path), false);
            return this;
        }

        public Builder tag(String location) {
            this.block = new ExtraCodecs.TagOrElementLocation(new ResourceLocation(location), true);
            return this;
        }

        public Builder tag(String namespace, String path) {
            this.block = new ExtraCodecs.TagOrElementLocation(new ResourceLocation(namespace, path), true);
            return this;
        }

        public Builder states(String ... states) {
            Collections.addAll(this.states, states);
            return this;
        }
    }
}

