/*
 * Decompiled with CFR 0.152.
 */
package com.agricraft.agricraft.api.genetic;

import com.agricraft.agricraft.api.AgriRegistry;
import com.agricraft.agricraft.api.genetic.AgriGene;
import com.agricraft.agricraft.api.genetic.GeneSpecies;
import com.agricraft.agricraft.api.genetic.GeneStat;
import com.agricraft.agricraft.api.stat.AgriStat;
import com.agricraft.agricraft.api.stat.AgriStatRegistry;
import java.util.Optional;

public class AgriGeneRegistry
extends AgriRegistry<AgriGene<?>> {
    private static AgriGeneRegistry INSTANCE;
    private final GeneSpecies geneSpecies = new GeneSpecies();

    public static AgriGeneRegistry getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new AgriGeneRegistry();
        }
        return INSTANCE;
    }

    private AgriGeneRegistry() {
        this.add(new GeneStat(AgriStatRegistry.getInstance().growthStat()));
        this.add(new GeneStat(AgriStatRegistry.getInstance().gainStat()));
        this.add(new GeneStat(AgriStatRegistry.getInstance().strengthStat()));
        this.add(new GeneStat(AgriStatRegistry.getInstance().fertilityStat()));
        this.add(new GeneStat(AgriStatRegistry.getInstance().resistanceStat()));
        this.add(new GeneStat(AgriStatRegistry.getInstance().mutativityStat()));
        this.add(this.geneSpecies);
    }

    public GeneSpecies getGeneSpecies() {
        return this.geneSpecies;
    }

    public Optional<AgriGene<Integer>> getGeneStat(AgriStat stat) {
        return this.get(stat.getId()).map(gene -> gene);
    }
}

