/*
 * Decompiled with CFR 0.152.
 */
package com.agricraft.agricraft.api.requirement;

import com.agricraft.agricraft.api.crop.AgriCrop;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;

public interface AgriGrowthResponse {
    public static final AgriGrowthResponse FERTILE = new AgriGrowthResponse(){

        @Override
        public boolean isFertile() {
            return true;
        }

        @Override
        public boolean isLethal() {
            return false;
        }

        public String toString() {
            return "AgriGrowthResponse{FERTILE}";
        }
    };
    public static final AgriGrowthResponse INFERTILE = new AgriGrowthResponse(){

        @Override
        public boolean isFertile() {
            return false;
        }

        @Override
        public boolean isLethal() {
            return false;
        }

        public String toString() {
            return "AgriGrowthResponse{INFERTILE}";
        }
    };
    public static final AgriGrowthResponse LETHAL = new AgriGrowthResponse(){

        @Override
        public boolean isFertile() {
            return false;
        }

        @Override
        public boolean isLethal() {
            return true;
        }

        public String toString() {
            return "AgriGrowthResponse{LETHAL}";
        }
    };
    public static final AgriGrowthResponse KILL_IT_WITH_FIRE = new AgriGrowthResponse(){

        @Override
        public boolean isFertile() {
            return false;
        }

        @Override
        public boolean isLethal() {
            return true;
        }

        @Override
        public boolean isInstantKill() {
            return true;
        }

        @Override
        public void onPlantKilled(AgriCrop crop) {
            Level world = crop.m_58904_();
            if (world instanceof ServerLevel) {
                double x = (double)crop.m_58899_().m_123341_() + 0.5;
                double y = (double)crop.m_58899_().m_123342_() + 0.5;
                double z = (double)crop.m_58899_().m_123343_() + 0.5;
                for (int i = 0; i < 3; ++i) {
                    world.m_7106_((ParticleOptions)ParticleTypes.f_123755_, x + 0.25 * world.m_213780_().m_188500_(), y, z + 0.25 * world.m_213780_().m_188500_(), 1.0, 0.0, 1.0);
                }
                world.m_6263_(null, x, y, z, SoundEvents.f_12031_, SoundSource.BLOCKS, 0.2f + world.m_213780_().m_188501_() * 0.2f, 0.9f + world.m_213780_().m_188501_() * 0.15f);
            }
        }

        public String toString() {
            return "AgriGrowthResponse{KILL_IT_WITH_FIRE}";
        }
    };

    public boolean isFertile();

    public boolean isLethal();

    default public boolean isInstantKill() {
        return false;
    }

    default public void onPlantKilled(AgriCrop crop) {
    }

    default public int priority() {
        if (this.isInstantKill()) {
            return 3;
        }
        if (this.isLethal()) {
            return 2;
        }
        if (!this.isFertile()) {
            return 1;
        }
        return 0;
    }
}

