/*
 * Decompiled with CFR 0.152.
 */
package com.agricraft.agricraft.client;

import com.agricraft.agricraft.client.gui.JournalScreen;
import com.agricraft.agricraft.common.block.CropStickVariant;
import com.agricraft.agricraft.common.item.JournalItem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.TerrainParticle;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ClientUtil {
    public static String getModelForSticks(CropStickVariant variant) {
        return switch (variant) {
            default -> throw new IncompatibleClassChangeError();
            case CropStickVariant.WOODEN -> "agricraft:block/wooden_crop_sticks";
            case CropStickVariant.IRON -> "agricraft:block/iron_crop_sticks";
            case CropStickVariant.OBSIDIAN -> "agricraft:block/obsidian_crop_sticks";
        };
    }

    public static void spawnParticlesForPlant(String plantModelId, LevelAccessor level, BlockState state, BlockPos pos) {
        BakedModel model = (BakedModel)Minecraft.m_91087_().m_91304_().f_119397_.get(new ResourceLocation(plantModelId));
        ClientUtil.spawnParticlesForModel(model, level, state, pos);
    }

    public static void spawnParticlesForSticks(CropStickVariant variant, LevelAccessor level, BlockState state, BlockPos pos) {
        String modelId = ClientUtil.getModelForSticks(variant);
        BakedModel model = (BakedModel)Minecraft.m_91087_().m_91304_().f_119397_.get(new ResourceLocation(modelId));
        ClientUtil.spawnParticlesForModel(model, level, state, pos);
    }

    public static void spawnParticlesForModel(BakedModel model, LevelAccessor level, BlockState state, BlockPos pos) {
        if (model == null) {
            return;
        }
        TextureAtlasSprite particleIcon = model.m_6160_();
        VoxelShape voxelShape = state.m_60808_((BlockGetter)level, pos);
        voxelShape.m_83286_((startX, startY, startZ, endX, endY, endZ) -> {
            double xBoxes = Math.min(1.0, endX - startX);
            double yBoxes = Math.min(1.0, endY - startY);
            double zBoxes = Math.min(1.0, endZ - startZ);
            int maxX = Math.max(2, Mth.m_14165_((double)(xBoxes / 0.25)));
            int maxY = Math.max(2, Mth.m_14165_((double)(yBoxes / 0.25)));
            int maxZ = Math.max(2, Mth.m_14165_((double)(zBoxes / 0.25)));
            for (int p = 0; p < maxX; ++p) {
                for (int q = 0; q < maxY; ++q) {
                    for (int r = 0; r < maxZ; ++r) {
                        double dx = ((double)p + 0.5) / (double)maxX;
                        double dy = ((double)q + 0.5) / (double)maxY;
                        double dz = ((double)r + 0.5) / (double)maxZ;
                        double ox = dx * xBoxes + startX;
                        double oy = dy * yBoxes + startY;
                        double oz = dz * zBoxes + startZ;
                        TerrainParticle particle = new TerrainParticle((ClientLevel)level, (double)pos.m_123341_() + ox, (double)pos.m_123342_() + oy, (double)pos.m_123343_() + oz, dx - 0.5, dy - 0.5, dz - 0.5, state, pos);
                        particle.m_108337_(particleIcon);
                        Minecraft.m_91087_().f_91061_.m_107344_((Particle)particle);
                    }
                }
            }
        });
    }

    public static void openJournalScreen(Player player, InteractionHand hand) {
        Minecraft.m_91087_().m_91152_((Screen)new JournalScreen(JournalItem.getJournalData(player.m_21120_(hand))));
    }
}

