/*
 * Decompiled with CFR 0.152.
 */
package com.agricraft.agricraft.compat.jei;

import com.agricraft.agricraft.api.plant.AgriPlant;
import com.agricraft.agricraft.common.item.AgriSeedItem;
import com.agricraft.agricraft.compat.jei.AgriCraftJeiPlugin;
import com.agricraft.agricraft.compat.jei.PlantIngredient;
import java.util.ArrayList;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class CropProduceCategory
implements IRecipeCategory<AgriPlant> {
    public static final ResourceLocation ID = new ResourceLocation("agricraft", "jei/produce");
    public static final RecipeType<AgriPlant> TYPE = new RecipeType(ID, AgriPlant.class);
    public static final IDrawable ICON = AgriCraftJeiPlugin.createDrawable(new ResourceLocation("agricraft", "textures/item/debugger.png"), 0, 0, 16, 16, 16, 16);
    public static final IDrawable BACKGROUND = AgriCraftJeiPlugin.createDrawable(new ResourceLocation("agricraft", "textures/gui/jei/crop_produce.png"), 0, 0, 128, 128, 128, 128);

    public RecipeType<AgriPlant> getRecipeType() {
        return TYPE;
    }

    public Component getTitle() {
        return Component.m_237115_((String)"agricraft.gui.jei.produce");
    }

    public IDrawable getBackground() {
        return BACKGROUND;
    }

    public IDrawable getIcon() {
        return ICON;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, AgriPlant plant, IFocusGroup focuses) {
        builder.setShapeless();
        builder.addSlot(RecipeIngredientRole.INPUT, 16, 9).setSlotName("input_seed").addIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)AgriSeedItem.toStack(plant));
        builder.addSlot(RecipeIngredientRole.INPUT, 16, 49).setSlotName("input_plant").setCustomRenderer(PlantIngredient.TYPE, PlantIngredient.RENDERER).addIngredient(PlantIngredient.TYPE, (Object)plant);
        int index = 0;
        ArrayList products = new ArrayList();
        plant.getAllPossibleProducts(products::add);
        for (int y = 33; y < 83 && index < products.size(); y += 18) {
            for (int x = 75; x < 129 && index < products.size(); ++index, x += 18) {
                ItemStack product = (ItemStack)products.get(index);
                IRecipeSlotBuilder slotBuilder = builder.addSlot(RecipeIngredientRole.OUTPUT, x, y).setSlotName("output_" + index);
                slotBuilder.addItemStack(product);
            }
        }
    }
}

