/*
 * Decompiled with CFR 0.152.
 */
package com.agricraft.agricraft.compat.wthit;

import com.agricraft.agricraft.api.AgriApi;
import com.agricraft.agricraft.api.codecs.AgriSoil;
import com.agricraft.agricraft.api.crop.AgriCrop;
import com.agricraft.agricraft.api.requirement.AgriGrowthConditionRegistry;
import com.agricraft.agricraft.api.requirement.AgriGrowthResponse;
import com.agricraft.agricraft.api.stat.AgriStat;
import com.agricraft.agricraft.api.stat.AgriStatRegistry;
import com.agricraft.agricraft.common.block.CropBlock;
import com.agricraft.agricraft.common.util.LangUtils;
import java.util.Comparator;
import java.util.Optional;
import mcp.mobius.waila.api.IBlockAccessor;
import mcp.mobius.waila.api.IBlockComponentProvider;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.IRegistrar;
import mcp.mobius.waila.api.ITooltip;
import mcp.mobius.waila.api.IWailaPlugin;
import mcp.mobius.waila.api.TooltipPosition;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;

public class AgriCraftWthitPlugin
implements IWailaPlugin {
    public void register(IRegistrar registrar) {
        registrar.addComponent((IBlockComponentProvider)CropBlockComponentProvider.INSTANCE, TooltipPosition.BODY, CropBlock.class);
        registrar.addComponent((IBlockComponentProvider)SoilComponentProvider.INSTANCE, TooltipPosition.BODY, Block.class);
    }

    public static class CropBlockComponentProvider
    implements IBlockComponentProvider {
        public static final CropBlockComponentProvider INSTANCE = new CropBlockComponentProvider();

        public void appendBody(ITooltip tooltip, IBlockAccessor accessor, IPluginConfig config) {
            BlockEntity blockEntity = accessor.getBlockEntity();
            if (blockEntity instanceof AgriCrop) {
                AgriCrop crop = (AgriCrop)blockEntity;
                if (crop.hasPlant()) {
                    tooltip.addLine((Component)Component.m_237110_((String)"agricraft.tooltip.jade.growth", (Object[])new Object[]{crop.getGrowthPercent() * 100.0}));
                    if (accessor.getPlayer().m_6144_()) {
                        tooltip.addLine((Component)Component.m_237115_((String)"agricraft.tooltip.jade.species").m_7220_(LangUtils.plantName(crop.getGenome().getSpeciesGene().getTrait())));
                        AgriStatRegistry.getInstance().stream().filter(stat -> !stat.isHidden()).map(stat -> crop.getGenome().getStatGene((AgriStat)stat)).sorted(Comparator.comparing(p -> p.getGene().getId())).map(genePair -> Component.m_237110_((String)("agricraft.tooltip.jade.stat." + genePair.getGene().getId()), (Object[])new Object[]{genePair.getTrait()})).forEach(arg_0 -> ((ITooltip)tooltip).addLine(arg_0));
                        AgriGrowthResponse response = crop.getFertilityResponse();
                        tooltip.addLine((Component)Component.m_237115_((String)("agricraft.tooltip.magnifying.requirement." + (response.isLethal() ? "lethal" : (response.isFertile() ? "fertile" : "not_fertile")))));
                        if (crop.m_58904_().f_46443_) {
                            crop.m_58904_().m_46465_();
                        }
                        if (!response.isFertile()) {
                            int strength = crop.getGenome().getStrength();
                            AgriGrowthConditionRegistry.getInstance().stream().filter(condition -> !condition.check(crop, crop.m_58904_(), crop.m_58899_(), strength).isFertile()).forEach(condition -> condition.notMetDescription(arg_0 -> ((ITooltip)tooltip).addLine(arg_0)));
                        }
                    }
                } else {
                    tooltip.addLine((Component)Component.m_237115_((String)"agricraft.tooltip.magnifying.no_plant"));
                }
                if (crop.hasWeeds()) {
                    tooltip.addLine((Component)Component.m_237115_((String)"agricraft.tooltip.magnifying.weeds").m_7220_(LangUtils.weedName(crop.getWeedId())));
                    if (accessor.getPlayer().m_6144_()) {
                        tooltip.addLine((Component)Component.m_237113_((String)"  ").m_7220_((Component)Component.m_237110_((String)"agricraft.tooltip.magnifying.growth", (Object[])new Object[]{crop.getWeedGrowthStage().index() + 1, crop.getWeedGrowthStage().total()})));
                    }
                }
            }
        }
    }

    public static class SoilComponentProvider
    implements IBlockComponentProvider {
        public static final SoilComponentProvider INSTANCE = new SoilComponentProvider();

        public void appendBody(ITooltip tooltip, IBlockAccessor accessor, IPluginConfig config) {
            Optional<AgriSoil> soil = AgriApi.getSoil((BlockGetter)accessor.getWorld(), accessor.getPosition(), accessor.getWorld().m_9598_());
            if (soil.isPresent() && accessor.getPlayer().m_6144_()) {
                AgriSoil soil1 = soil.get();
                tooltip.addLine((Component)Component.m_237115_((String)"agricraft.tooltip.magnifying.soil.humidity").m_7220_((Component)Component.m_237115_((String)("agricraft.soil.humidity." + soil1.humidity().name().toLowerCase()))));
                tooltip.addLine((Component)Component.m_237115_((String)"agricraft.tooltip.magnifying.soil.acidity").m_7220_((Component)Component.m_237115_((String)("agricraft.soil.acidity." + soil1.acidity().name().toLowerCase()))));
                tooltip.addLine((Component)Component.m_237115_((String)"agricraft.tooltip.magnifying.soil.nutrients").m_7220_((Component)Component.m_237115_((String)("agricraft.soil.nutrients." + soil1.nutrients().name().toLowerCase()))));
            }
        }
    }
}

