/*
 * Decompiled with CFR 0.152.
 */
package com.agricraft.agricraft.plugin.minecraft;

import com.agricraft.agricraft.api.crop.AgriCrop;
import com.agricraft.agricraft.api.genetic.AgriGenePair;
import com.agricraft.agricraft.api.plant.AgriPlantModifierFactoryRegistry;
import com.agricraft.agricraft.api.plant.IAgriPlantModifier;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.FungusBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MinecraftPlantModifiers {
    public static void register() {
        AgriPlantModifierFactoryRegistry.register("agricraft:brightness", info -> Optional.of(new BrightnessPlantModifier()));
        AgriPlantModifierFactoryRegistry.register("agricraft:burn", info -> Optional.of(new BurnPlantModifier()));
        AgriPlantModifierFactoryRegistry.register("agricraft:bushy", info -> Optional.of(new BushyPlantModifier()));
        AgriPlantModifierFactoryRegistry.register("agricraft:experience", info -> Optional.of(new ExperiencePlantModifier()));
        AgriPlantModifierFactoryRegistry.register("agricraft:fungus", info -> {
            Block block = (Block)BuiltInRegistries.f_256975_.m_7745_(new ResourceLocation(info.value()));
            if (block instanceof FungusBlock) {
                FungusBlock fungus = (FungusBlock)block;
                return Optional.of(new FungusPlantModifier(fungus));
            }
            return Optional.empty();
        });
        AgriPlantModifierFactoryRegistry.register("agricraft:poison", info -> Optional.of(new PoisonPlantModifier()));
        AgriPlantModifierFactoryRegistry.register("agricraft:redstone", info -> Optional.of(new RedstonePlantModifier()));
        AgriPlantModifierFactoryRegistry.register("agricraft:summon", info -> {
            if (BuiltInRegistries.f_256780_.m_7804_(new ResourceLocation(info.value()))) {
                return Optional.of(new SummonPlantModifier((EntityType)BuiltInRegistries.f_256780_.m_7745_(new ResourceLocation(info.value()))));
            }
            return Optional.empty();
        });
        AgriPlantModifierFactoryRegistry.register("agricraft:thorns", info -> Optional.of(new ThornsPlantModifier()));
        AgriPlantModifierFactoryRegistry.register("agricraft:tree", info -> {
            Block block = (Block)BuiltInRegistries.f_256975_.m_7745_(new ResourceLocation(info.value()));
            if (block instanceof BonemealableBlock) {
                BonemealableBlock sapling = (BonemealableBlock)block;
                return Optional.of(new TreePlantModifier(sapling));
            }
            return Optional.empty();
        });
        AgriPlantModifierFactoryRegistry.register("agricraft:wither", info -> Optional.of(new WitherPlantModifier()));
    }

    public static class BrightnessPlantModifier
    implements IAgriPlantModifier {
        public static final String ID = "agricraft:brightness";

        @Override
        public int getBrightness(AgriCrop crop) {
            return (int)(16.0 * crop.getGrowthPercent());
        }
    }

    public static class BurnPlantModifier
    implements IAgriPlantModifier {
        public static final String ID = "agricraft:burn";

        @Override
        public void onEntityCollision(AgriCrop crop, Entity entity) {
            entity.m_20254_((int)crop.getGenome().getStatGenes().stream().map(AgriGenePair::getTrait).mapToInt(i -> i).average().orElse(0.0));
        }
    }

    public static class BushyPlantModifier
    implements IAgriPlantModifier {
        public static final String ID = "agricraft:bushy";

        @Override
        public void onEntityCollision(AgriCrop crop, Entity entity) {
            entity.m_7601_(crop.m_58900_(), new Vec3(0.8, 0.75, 0.8));
        }
    }

    public static class ExperiencePlantModifier
    implements IAgriPlantModifier {
        public static final String ID = "agricraft:experience";

        @Override
        public void onHarvest(AgriCrop crop, @Nullable LivingEntity entity) {
            if (crop.m_58904_() != null && !crop.m_58904_().f_46443_) {
                for (int i = 0; i < crop.getGenome().getGain(); ++i) {
                    if (i != 0 && !(crop.m_58904_().m_213780_().m_188500_() < 0.5)) continue;
                    BlockPos pos = crop.m_58899_();
                    crop.m_58904_().m_7967_((Entity)new ExperienceOrb(crop.m_58904_(), (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 4));
                }
            }
        }
    }

    public static class FungusPlantModifier
    implements IAgriPlantModifier {
        public static final String ID = "agricraft:fungus";
        private final FungusBlock fungus;

        public FungusPlantModifier(FungusBlock fungus) {
            this.fungus = fungus;
        }

        @Override
        public Optional<InteractionResult> onRightClickPre(AgriCrop crop, @NotNull ItemStack stack, @Nullable Entity entity) {
            Level level = crop.m_58904_();
            if (stack.m_41619_() || stack.m_41720_() != Items.f_42499_ || crop.m_58904_() == null || !crop.canBeHarvested() || !this.fungus.m_7370_((LevelReader)level, crop.m_58899_(), crop.m_58900_(), level.f_46443_)) {
                return Optional.empty();
            }
            if (this.fungus.m_214167_(level, level.f_46441_, crop.m_58899_(), crop.m_58900_())) {
                this.fungus.m_214148_((ServerLevel)level, level.f_46441_, crop.m_58899_(), crop.m_58900_());
                level.m_46796_(2005, crop.m_58899_(), 0);
            }
            stack.m_41774_(1);
            return Optional.of(InteractionResult.SUCCESS);
        }
    }

    public static class PoisonPlantModifier
    implements IAgriPlantModifier {
        public static final String ID = "agricraft:poison";

        @Override
        public void onEntityCollision(AgriCrop crop, Entity entity) {
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                if (!(entity.m_20163_() || entity.m_9236_().f_46443_ || livingEntity.m_21023_(MobEffects.f_19614_))) {
                    livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19614_, (int)(20.0 * crop.getGenome().getStatGenes().stream().map(AgriGenePair::getTrait).mapToInt(i -> i).average().orElse(0.0))));
                }
            }
        }
    }

    public static class RedstonePlantModifier
    implements IAgriPlantModifier {
        public static final String ID = "agricraft:redstone";

        @Override
        public int getBrightness(AgriCrop crop) {
            return (int)(15.0 * crop.getGrowthPercent());
        }
    }

    public static class SummonPlantModifier
    implements IAgriPlantModifier {
        public static final String ID = "agricraft:summon";
        private final EntityType<?> entityType;

        public SummonPlantModifier(EntityType<?> entityType) {
            this.entityType = entityType;
        }

        @Override
        public void onHarvest(AgriCrop crop, @Nullable LivingEntity entity) {
            if (entity instanceof Player) {
                ServerLevel serverLevel;
                Player player = (Player)entity;
                Level level = crop.m_58904_();
                if (level instanceof ServerLevel && this.entityType.m_20592_(serverLevel = (ServerLevel)level, null, player, crop.m_58899_(), MobSpawnType.MOB_SUMMONED, true, false) != null) {
                    serverLevel.m_142346_((Entity)player, GameEvent.f_157810_, crop.m_58899_());
                }
            }
        }
    }

    public static class ThornsPlantModifier
    implements IAgriPlantModifier {
        public static final String ID = "agricraft:thorns";

        @Override
        public void onEntityCollision(AgriCrop crop, Entity entity) {
            ItemEntity itemEntity;
            if (entity instanceof ItemEntity && (itemEntity = (ItemEntity)entity).m_32059_() < 100) {
                return;
            }
            double damage = crop.getGrowthPercent() * crop.getGenome().getStatGenes().stream().map(AgriGenePair::getTrait).mapToInt(i -> i).average().orElse(0.0);
            entity.m_6469_(crop.m_58904_().m_269111_().m_269325_(), (float)damage);
        }
    }

    public static class TreePlantModifier
    implements IAgriPlantModifier {
        public static final String ID = "agricraft:tree";
        private final BonemealableBlock sapling;

        public TreePlantModifier(BonemealableBlock sapling) {
            this.sapling = sapling;
        }

        @Override
        public Optional<InteractionResult> onRightClickPre(AgriCrop crop, @NotNull ItemStack stack, @Nullable Entity entity) {
            ServerLevel serverLevel;
            Level level;
            block7: {
                block6: {
                    level = crop.m_58904_();
                    if (stack.m_41619_() || stack.m_41720_() != Items.f_42499_ || crop.m_58904_() == null || !crop.canBeHarvested() || !(level instanceof ServerLevel)) break block6;
                    serverLevel = (ServerLevel)level;
                    if (this.sapling.m_7370_((LevelReader)level, crop.m_58899_(), crop.m_58900_(), level.f_46443_)) break block7;
                }
                return Optional.empty();
            }
            if (this.sapling.m_214167_(level, level.f_46441_, crop.m_58899_(), crop.m_58900_())) {
                BlockState state = ((Block)this.sapling).m_49966_();
                if (state.m_61138_((Property)SaplingBlock.f_55973_)) {
                    state = (BlockState)state.m_61124_((Property)SaplingBlock.f_55973_, (Comparable)Integer.valueOf(1));
                }
                CompoundTag before = crop.asBlockEntity().m_187482_();
                this.sapling.m_214148_(serverLevel, serverLevel.m_213780_(), crop.m_58899_(), state);
                if (serverLevel.m_8055_(crop.m_58899_()).m_60734_().equals(this.sapling)) {
                    serverLevel.m_46597_(crop.m_58899_(), crop.m_58900_());
                    serverLevel.m_7702_(crop.m_58899_()).m_142466_(before);
                    return Optional.of(InteractionResult.CONSUME);
                }
                serverLevel.m_46796_(2005, crop.m_58899_(), 0);
            }
            stack.m_41774_(1);
            return Optional.of(InteractionResult.SUCCESS);
        }
    }

    public static class WitherPlantModifier
    implements IAgriPlantModifier {
        public static final String ID = "agricraft:wither";

        @Override
        public void onEntityCollision(AgriCrop crop, Entity entity) {
            if (entity instanceof LivingEntity) {
                MobEffectInstance wither = new MobEffectInstance(MobEffects.f_19615_, (int)(10.0 * crop.getGenome().getStatGenes().stream().map(AgriGenePair::getTrait).mapToInt(i -> i).average().orElse(0.0)));
                ((LivingEntity)entity).m_7292_(wither);
            }
        }
    }
}

