/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.meadow.client.renderer.block;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.Map;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.Material;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CeilingHangingSignBlock;
import net.minecraft.world.level.block.SignBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.satisfy.meadow.client.renderer.block.ModSignRenderer;
import net.satisfy.meadow.core.block.entity.ModSignBlockEntity;

@OnlyIn(value=Dist.CLIENT)
public class ModHangingSignRenderer
extends ModSignRenderer {
    private static final String PLANK = "plank";
    private static final String V_CHAINS = "vChains";
    private static final String NORMAL_CHAINS = "normalChains";
    private static final String CHAIN_L_1 = "chainL1";
    private static final String CHAIN_L_2 = "chainL2";
    private static final String CHAIN_R_1 = "chainR1";
    private static final String CHAIN_R_2 = "chainR2";
    private static final String BOARD = "board";
    private static final float MODEL_RENDER_SCALE = 1.0f;
    private static final float TEXT_RENDER_SCALE = 0.9f;
    private static final Vec3 TEXT_OFFSET = new Vec3(0.0, (double)-0.32f, (double)0.073f);
    private final Map hangingSignModels = (Map)WoodType.m_61843_().collect(ImmutableMap.toImmutableMap(woodType -> woodType, woodType -> new HangingSignModel(context.m_173582_(ModelLayers.m_247439_((WoodType)woodType)))));

    public ModHangingSignRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    @Override
    public float getSignModelRenderScale() {
        return 1.0f;
    }

    @Override
    public float getSignTextRenderScale() {
        return 0.9f;
    }

    @Override
    public void render(ModSignBlockEntity signBlockEntity, float f, PoseStack poseStack, MultiBufferSource multiBufferSource, int i, int j) {
        BlockState blockState = signBlockEntity.m_58900_();
        SignBlock signBlock = (SignBlock)blockState.m_60734_();
        WoodType woodType = SignBlock.m_247329_((Block)signBlock);
        HangingSignModel hangingSignModel = (HangingSignModel)((Object)this.hangingSignModels.get(woodType));
        hangingSignModel.evaluateVisibleParts(blockState);
        this.renderSignWithText(signBlockEntity, poseStack, multiBufferSource, i, j, blockState, signBlock, woodType, hangingSignModel);
    }

    @Override
    void translateSign(PoseStack poseStack, float f, BlockState blockState) {
        poseStack.m_85837_(0.5, 0.9375, 0.5);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(f));
        poseStack.m_252880_(0.0f, -0.3125f, 0.0f);
    }

    @Override
    void renderSignModel(PoseStack poseStack, int i, int j, Model model, VertexConsumer vertexConsumer) {
        HangingSignModel hangingSignModel = (HangingSignModel)model;
        hangingSignModel.root.m_104301_(poseStack, vertexConsumer, i, j);
    }

    @Override
    Material getSignMaterial(WoodType woodType) {
        return Sheets.m_246984_((WoodType)woodType);
    }

    @Override
    Vec3 getTextOffset() {
        return TEXT_OFFSET;
    }

    public static LayerDefinition createHangingSignLayer() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.m_171576_();
        partDefinition.m_171599_(BOARD, CubeListBuilder.m_171558_().m_171514_(0, 12).m_171481_(-7.0f, 0.0f, -1.0f, 14.0f, 10.0f, 2.0f), PartPose.f_171404_);
        partDefinition.m_171599_(PLANK, CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-8.0f, -6.0f, -2.0f, 16.0f, 2.0f, 4.0f), PartPose.f_171404_);
        PartDefinition partDefinition2 = partDefinition.m_171599_(NORMAL_CHAINS, CubeListBuilder.m_171558_(), PartPose.f_171404_);
        partDefinition2.m_171599_(CHAIN_L_1, CubeListBuilder.m_171558_().m_171514_(0, 6).m_171481_(-1.5f, 0.0f, 0.0f, 3.0f, 6.0f, 0.0f), PartPose.m_171423_((float)-5.0f, (float)-6.0f, (float)0.0f, (float)0.0f, (float)-0.7853982f, (float)0.0f));
        partDefinition2.m_171599_(CHAIN_L_2, CubeListBuilder.m_171558_().m_171514_(6, 6).m_171481_(-1.5f, 0.0f, 0.0f, 3.0f, 6.0f, 0.0f), PartPose.m_171423_((float)-5.0f, (float)-6.0f, (float)0.0f, (float)0.0f, (float)0.7853982f, (float)0.0f));
        partDefinition2.m_171599_(CHAIN_R_1, CubeListBuilder.m_171558_().m_171514_(0, 6).m_171481_(-1.5f, 0.0f, 0.0f, 3.0f, 6.0f, 0.0f), PartPose.m_171423_((float)5.0f, (float)-6.0f, (float)0.0f, (float)0.0f, (float)-0.7853982f, (float)0.0f));
        partDefinition2.m_171599_(CHAIN_R_2, CubeListBuilder.m_171558_().m_171514_(6, 6).m_171481_(-1.5f, 0.0f, 0.0f, 3.0f, 6.0f, 0.0f), PartPose.m_171423_((float)5.0f, (float)-6.0f, (float)0.0f, (float)0.0f, (float)0.7853982f, (float)0.0f));
        partDefinition.m_171599_(V_CHAINS, CubeListBuilder.m_171558_().m_171514_(14, 6).m_171481_(-6.0f, -6.0f, 0.0f, 12.0f, 6.0f, 0.0f), PartPose.f_171404_);
        return LayerDefinition.m_171565_((MeshDefinition)meshDefinition, (int)64, (int)32);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static final class HangingSignModel
    extends Model {
        public final ModelPart root;
        public final ModelPart plank;
        public final ModelPart vChains;
        public final ModelPart normalChains;

        public HangingSignModel(ModelPart modelPart) {
            super(RenderType::m_110458_);
            this.root = modelPart;
            this.plank = modelPart.m_171324_(ModHangingSignRenderer.PLANK);
            this.normalChains = modelPart.m_171324_(ModHangingSignRenderer.NORMAL_CHAINS);
            this.vChains = modelPart.m_171324_(ModHangingSignRenderer.V_CHAINS);
        }

        public void evaluateVisibleParts(BlockState blockState) {
            boolean bl;
            this.plank.f_104207_ = bl = !(blockState.m_60734_() instanceof CeilingHangingSignBlock);
            this.vChains.f_104207_ = false;
            this.normalChains.f_104207_ = true;
            if (!bl) {
                boolean bl2 = (Boolean)blockState.m_61143_((Property)BlockStateProperties.f_61386_);
                this.normalChains.f_104207_ = !bl2;
                this.vChains.f_104207_ = bl2;
            }
        }

        public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int i, int j, float f, float g, float h, float k) {
            this.root.m_104306_(poseStack, vertexConsumer, i, j, f, g, h, k);
        }
    }
}

