/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.meadow.client.renderer.entity;

import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.resources.ResourceLocation;
import net.satisfy.meadow.client.model.WoolySheepModel;
import net.satisfy.meadow.client.renderer.entity.WoolySheepFurLayerRenderer;
import net.satisfy.meadow.core.entity.WoolySheepEntity;
import net.satisfy.meadow.core.entity.WoolySheepVar;
import net.satisfy.meadow.core.util.MeadowIdentifier;
import org.jetbrains.annotations.NotNull;

public class WoolySheepRenderer
extends MobRenderer<WoolySheepEntity, WoolySheepModel<WoolySheepEntity>> {
    private static final ResourceLocation FLECKED_WOOL_TEXTURE = new MeadowIdentifier("textures/entity/sheep/flecked_sheep.png");
    private static final ResourceLocation PATCHED_WOOL_TEXTURE = new MeadowIdentifier("textures/entity/sheep/patched_sheep.png");
    private static final ResourceLocation ROCKY_WOOL_TEXTURE = new MeadowIdentifier("textures/entity/sheep/rocky_sheep.png");
    private static final ResourceLocation INKY_WOOL_TEXTURE = new MeadowIdentifier("textures/entity/sheep/inky_sheep.png");
    private static final ResourceLocation FUZZY_WOOL_TEXTURE = new MeadowIdentifier("textures/entity/sheep/fuzzy_sheep.png");
    private static final ResourceLocation LONG_NOSED_WOOL_TEXTURE = new MeadowIdentifier("textures/entity/sheep/long_nosed_sheep.png");
    private static final ResourceLocation FLECKED_WOOL_TEXTURE_SHORN = new MeadowIdentifier("textures/entity/sheep/flecked_sheep.png");
    private static final ResourceLocation PATCHED_WOOL_TEXTURE_SHORN = new MeadowIdentifier("textures/entity/sheep/patched_sheep.png");
    private static final ResourceLocation ROCKY_WOOL_TEXTURE_SHORN = new MeadowIdentifier("textures/entity/sheep/rocky_sheep.png");
    private static final ResourceLocation INKY_WOOL_TEXTURE_SHORN = new MeadowIdentifier("textures/entity/sheep/inky_sheep.png");
    private static final ResourceLocation FUZZY_WOOL_TEXTURE_SHORN = new MeadowIdentifier("textures/entity/sheep/fuzzy_sheep.png");
    private static final ResourceLocation LONG_NOSED_WOOL_TEXTURE_SHORN = new MeadowIdentifier("textures/entity/sheep/long_nosed_sheep.png");

    public WoolySheepRenderer(EntityRendererProvider.Context context) {
        super(context, new WoolySheepModel(context.m_174023_(ModelLayers.f_171177_)), 0.7f);
        this.m_115326_(new WoolySheepFurLayerRenderer((RenderLayerParent<WoolySheepEntity, WoolySheepModel<WoolySheepEntity>>)this, context));
    }

    @NotNull
    public ResourceLocation getTextureLocation(WoolySheepEntity entity) {
        if (entity.isSheared()) {
            return switch (entity.getVariant()) {
                case WoolySheepVar.PATCHED -> PATCHED_WOOL_TEXTURE_SHORN;
                case WoolySheepVar.ROCKY -> ROCKY_WOOL_TEXTURE_SHORN;
                case WoolySheepVar.INKY -> INKY_WOOL_TEXTURE_SHORN;
                case WoolySheepVar.FUZZY -> FUZZY_WOOL_TEXTURE_SHORN;
                case WoolySheepVar.LONG_NOSED -> LONG_NOSED_WOOL_TEXTURE_SHORN;
                default -> FLECKED_WOOL_TEXTURE_SHORN;
            };
        }
        return switch (entity.getVariant()) {
            case WoolySheepVar.PATCHED -> PATCHED_WOOL_TEXTURE;
            case WoolySheepVar.ROCKY -> ROCKY_WOOL_TEXTURE;
            case WoolySheepVar.INKY -> INKY_WOOL_TEXTURE;
            case WoolySheepVar.FUZZY -> FUZZY_WOOL_TEXTURE;
            case WoolySheepVar.LONG_NOSED -> LONG_NOSED_WOOL_TEXTURE;
            default -> FLECKED_WOOL_TEXTURE;
        };
    }
}

