/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.meadow.core.world;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;

public class CommonSpawnUtil {
    public static final int cowSpawnWeight = 6;
    public static final int cowPackSizeMin = 2;
    public static final int cowPackSizeMax = 3;
    public static final int sheepSpawnWeight = 6;
    public static final int sheepPackSizeMin = 2;
    public static final int sheepPackSizeMax = 3;

    public static boolean spawnsInBiome(Holder<Biome> biome, boolean checkForMeadowSpawn, EntityType<?> ... entityTypes) {
        return CommonSpawnUtil.spawnsInBiome(biome, checkForMeadowSpawn, ImmutableSet.copyOf((Object[])entityTypes));
    }

    public static boolean spawnsInBiome(Holder<Biome> biome, boolean checkForMeadowSpawn, Set<EntityType<?>> entityTypes) {
        MobSpawnSettings spawnSettings = ((Biome)biome.m_203334_()).m_47518_();
        for (MobCategory spawnGroup : MobCategory.values()) {
            for (MobSpawnSettings.SpawnerData spawnEntry : spawnSettings.m_151798_(spawnGroup).m_146338_()) {
                if (checkForMeadowSpawn && CommonSpawnUtil.isMeadowSpawn(spawnEntry)) {
                    return false;
                }
                if (!entityTypes.contains(spawnEntry.f_48404_)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isMeadowSpawn(MobSpawnSettings.SpawnerData spawnEntry) {
        EntityType type = spawnEntry.f_48404_;
        if (type.equals(EntityType.f_20557_)) {
            return spawnEntry.f_48406_ == 3 && spawnEntry.f_48405_ == 2;
        }
        if (type.equals(EntityType.f_20520_)) {
            return spawnEntry.f_48406_ == 3 && spawnEntry.f_48405_ == 2;
        }
        return false;
    }
}

