/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.farm_and_charm.core.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.farm_and_charm.core.util.GeneralUtil;
import org.jetbrains.annotations.NotNull;

public class StackableBlock
extends Block {
    private static final IntegerProperty STACK_PROPERTY = IntegerProperty.m_61631_((String)"stack", (int)1, (int)8);
    private static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    private final int maxStack;
    private static final VoxelShape SHAPE = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)10.0, (double)14.0);

    public StackableBlock(BlockBehaviour.Properties settings, int maxStack) {
        super(settings);
        this.maxStack = maxStack;
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)STACK_PROPERTY, (Comparable)Integer.valueOf(1))).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{STACK_PROPERTY, FACING});
    }

    @NotNull
    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    @NotNull
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    @NotNull
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack stack = player.m_21120_(hand);
        if (player.m_6144_() && stack.m_41619_()) {
            if (!world.f_46443_) {
                if ((Integer)state.m_61143_((Property)STACK_PROPERTY) > 1) {
                    world.m_7731_(pos, (BlockState)state.m_61124_((Property)STACK_PROPERTY, (Comparable)Integer.valueOf((Integer)state.m_61143_((Property)STACK_PROPERTY) - 1)), 3);
                } else {
                    world.m_7471_(pos, false);
                }
                ItemStack droppedStack = new ItemStack((ItemLike)this.m_5456_());
                if (!player.m_150109_().m_36054_(droppedStack)) {
                    GeneralUtil.spawnSlice(world, droppedStack, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 0.0, 0.1, 0.0);
                }
                world.m_5594_(null, pos, SoundEvents.f_11912_, SoundSource.PLAYERS, 1.0f, 1.0f);
                if (world instanceof ServerLevel) {
                    ServerLevel serverWorld = (ServerLevel)world;
                    for (int count = 0; count < 10; ++count) {
                        double d0 = world.f_46441_.m_188583_() * 0.02;
                        double d1 = world.f_46441_.m_188583_() * 0.0;
                        double d2 = world.f_46441_.m_188583_() * 0.02;
                        serverWorld.m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, state), (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.0, (double)pos.m_123343_() + 0.5, 1, d0, d1, d2, 0.1);
                    }
                }
                return InteractionResult.m_19078_((boolean)world.f_46443_);
            }
        } else if (stack.m_41720_() == this.m_5456_()) {
            if ((Integer)state.m_61143_((Property)STACK_PROPERTY) < this.maxStack) {
                world.m_7731_(pos, (BlockState)state.m_61124_((Property)STACK_PROPERTY, (Comparable)Integer.valueOf((Integer)state.m_61143_((Property)STACK_PROPERTY) + 1)), 3);
                if (!player.m_7500_()) {
                    stack.m_41774_(1);
                }
                return InteractionResult.SUCCESS;
            }
        } else if (stack.m_41619_()) {
            if ((Integer)state.m_61143_((Property)STACK_PROPERTY) > 1) {
                world.m_7731_(pos, (BlockState)state.m_61124_((Property)STACK_PROPERTY, (Comparable)Integer.valueOf((Integer)state.m_61143_((Property)STACK_PROPERTY) - 1)), 3);
            } else if ((Integer)state.m_61143_((Property)STACK_PROPERTY) == 1) {
                world.m_46961_(pos, false);
            }
            Direction direction = player.m_6350_().m_122424_();
            double xMotion = (double)direction.m_122429_() * 0.13;
            double yMotion = 0.35;
            double zMotion = (double)direction.m_122431_() * 0.13;
            GeneralUtil.spawnSlice(world, new ItemStack((ItemLike)this), (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, xMotion, yMotion, zMotion);
            return InteractionResult.SUCCESS;
        }
        return super.m_6227_(state, world, pos, player, hand, hit);
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        VoxelShape shape = world.m_8055_(pos.m_7495_()).m_60808_((BlockGetter)world, pos.m_7495_());
        Direction direction = Direction.UP;
        return Block.m_49918_((VoxelShape)shape, (Direction)direction);
    }

    public void m_213897_(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if (!state.m_60710_((LevelReader)world, pos)) {
            world.m_46961_(pos, true);
        }
    }

    @NotNull
    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (!state.m_60710_((LevelReader)world, pos)) {
            world.m_186460_(pos, (Block)this, 1);
        }
        return super.m_7417_(state, direction, neighborState, world, pos, neighborPos);
    }
}

