/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.farm_and_charm.core.block.entity;

import java.util.Objects;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.satisfy.farm_and_charm.core.block.CraftingBowlBlock;
import net.satisfy.farm_and_charm.core.recipe.CraftingBowlRecipe;
import net.satisfy.farm_and_charm.core.registry.EntityTypeRegistry;
import net.satisfy.farm_and_charm.core.registry.RecipeTypeRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CraftingBowlBlockEntity
extends RandomizableContainerBlockEntity
implements WorldlyContainer,
BlockEntityTicker<CraftingBowlBlockEntity> {
    private NonNullList<ItemStack> stacks = NonNullList.m_122780_((int)5, (Object)ItemStack.f_41583_);

    public CraftingBowlBlockEntity(BlockPos position, BlockState state) {
        super((BlockEntityType)EntityTypeRegistry.CRAFTING_BOWL_BLOCK_ENTITY.get(), position, state);
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        if (!this.m_59631_(compound)) {
            this.stacks = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        }
        ContainerHelper.m_18980_((CompoundTag)compound, this.stacks);
    }

    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        if (!this.m_59634_(compound)) {
            ContainerHelper.m_18973_((CompoundTag)compound, this.stacks);
        }
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @NotNull
    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public int m_6643_() {
        return this.stacks.size();
    }

    public boolean m_7983_() {
        for (ItemStack itemstack : this.stacks) {
            if (itemstack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public Component m_6820_() {
        return Component.m_237113_((String)"crafting_bowl");
    }

    @NotNull
    public AbstractContainerMenu m_6555_(int id, Inventory inventory) {
        return ChestMenu.m_39255_((int)id, (Inventory)inventory);
    }

    public int m_6893_() {
        return 64;
    }

    public boolean m_7013_(int index, ItemStack stack) {
        return true;
    }

    @NotNull
    public NonNullList<ItemStack> m_7086_() {
        return this.stacks;
    }

    protected void m_6520_(NonNullList<ItemStack> stacks) {
        this.stacks = stacks;
    }

    public int filledSlots() {
        int count = 0;
        for (ItemStack stack : this.stacks) {
            if (stack.m_41619_()) continue;
            ++count;
        }
        return count;
    }

    public boolean canAddItem(ItemStack stack) {
        return this.m_7013_(0, stack) && this.filledSlots() < this.m_6643_();
    }

    public void addItemStack(ItemStack stack) {
        for (int j = 0; j < this.m_6643_(); ++j) {
            if (this.m_8020_(j) != ItemStack.f_41583_) continue;
            this.m_6836_(j, stack);
            this.m_6596_();
            return;
        }
    }

    public int @NotNull [] m_7071_(Direction side) {
        return IntStream.range(0, this.m_6643_()).toArray();
    }

    public boolean m_7155_(int index, ItemStack stack, @Nullable Direction direction) {
        return this.m_7013_(index, stack);
    }

    public boolean m_7157_(int index, ItemStack stack, Direction direction) {
        return true;
    }

    private ItemStack getRemainderItem(ItemStack stack) {
        if (stack.m_41720_().m_41470_()) {
            return new ItemStack((ItemLike)Objects.requireNonNull(stack.m_41720_().m_41469_()));
        }
        return ItemStack.f_41583_;
    }

    public int getStirringProgress() {
        return (Integer)this.m_58900_().m_61143_((Property)CraftingBowlBlock.STIRRED);
    }

    public void tick(Level level, BlockPos blockPos, BlockState blockState, CraftingBowlBlockEntity blockEntity) {
        if (!level.f_46443_ && level.m_8055_(blockPos).m_60734_() instanceof CraftingBowlBlock) {
            int stirring = (Integer)blockState.m_61143_((Property)CraftingBowlBlock.STIRRING);
            int stirred = (Integer)blockState.m_61143_((Property)CraftingBowlBlock.STIRRED);
            if (stirring > 0) {
                if (stirred < 50) {
                    CraftingBowlRecipe recipe = level.m_7465_().m_44015_((RecipeType)RecipeTypeRegistry.CRAFTING_BOWL_RECIPE_TYPE.get(), (Container)blockEntity, level).orElse(null);
                    if (++stirred == 50 && recipe != null) {
                        recipe.m_7527_().forEach(ingredient -> {
                            int size = blockEntity.m_7086_().size();
                            for (int slot = 0; slot < size; ++slot) {
                                ItemStack stack = blockEntity.m_8020_(slot);
                                if (!ingredient.test(stack)) continue;
                                ItemStack remainder = this.getRemainderItem(stack);
                                stack.m_41774_(1);
                                if (!stack.m_41619_()) break;
                                blockEntity.m_6836_(slot, ItemStack.f_41583_);
                                if (remainder.m_41619_()) break;
                                double offsetX = level.f_46441_.m_188500_() * 0.7 + 0.15;
                                double offsetY = level.f_46441_.m_188500_() * 0.7 + 0.15;
                                double offsetZ = level.f_46441_.m_188500_() * 0.7 + 0.15;
                                ItemEntity itemEntity = new ItemEntity(level, (double)blockPos.m_123341_() + offsetX, (double)blockPos.m_123342_() + offsetY, (double)blockPos.m_123343_() + offsetZ, remainder);
                                level.m_7967_((Entity)itemEntity);
                                break;
                            }
                        });
                        ItemStack resultItem = recipe.m_8043_(level.m_9598_()).m_41777_();
                        resultItem.m_41764_(recipe.getOutputCount());
                        blockEntity.m_6836_(4, resultItem);
                    }
                }
                level.m_7731_(blockPos, (BlockState)((BlockState)blockState.m_61124_((Property)CraftingBowlBlock.STIRRING, (Comparable)Integer.valueOf(--stirring))).m_61124_((Property)CraftingBowlBlock.STIRRED, (Comparable)Integer.valueOf(stirred)), 3);
            } else if (stirred > 0 && stirred < 50) {
                level.m_7731_(blockPos, (BlockState)blockState.m_61124_((Property)CraftingBowlBlock.STIRRED, (Comparable)Integer.valueOf(0)), 3);
            }
        }
    }
}

