/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.farm_and_charm.core.registry;

import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.Registrar;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.satisfy.farm_and_charm.core.recipe.CookingPotRecipe;
import net.satisfy.farm_and_charm.core.recipe.CraftingBowlRecipe;
import net.satisfy.farm_and_charm.core.recipe.MincerRecipe;
import net.satisfy.farm_and_charm.core.recipe.RoasterRecipe;
import net.satisfy.farm_and_charm.core.recipe.SiloRecipe;
import net.satisfy.farm_and_charm.core.recipe.StoveRecipe;
import net.satisfy.farm_and_charm.core.util.FarmAndCharmIdentifier;

public class RecipeTypeRegistry {
    private static final Registrar<RecipeType<?>> RECIPE_TYPES = DeferredRegister.create((String)"farm_and_charm", (ResourceKey)Registries.f_256954_).getRegistrar();
    private static final Registrar<RecipeSerializer<?>> RECIPE_SERIALIZERS = DeferredRegister.create((String)"farm_and_charm", (ResourceKey)Registries.f_256764_).getRegistrar();
    public static final RegistrySupplier<RecipeType<CookingPotRecipe>> COOKING_POT_RECIPE_TYPE = RecipeTypeRegistry.create("pot_cooking");
    public static final RegistrySupplier<RecipeType<CraftingBowlRecipe>> CRAFTING_BOWL_RECIPE_TYPE = RecipeTypeRegistry.create("crafting_bowl");
    public static final RegistrySupplier<RecipeType<StoveRecipe>> STOVE_RECIPE_TYPE = RecipeTypeRegistry.create("stove");
    public static final RegistrySupplier<RecipeType<MincerRecipe>> MINCER_RECIPE_TYPE = RecipeTypeRegistry.create("mincer");
    public static final RegistrySupplier<RecipeType<RoasterRecipe>> ROASTER_RECIPE_TYPE = RecipeTypeRegistry.create("roaster");
    public static final RegistrySupplier<RecipeType<SiloRecipe>> SILO_RECIPE_TYPE = RecipeTypeRegistry.create("drying");
    public static final RegistrySupplier<RecipeSerializer<CookingPotRecipe>> COOKING_POT_RECIPE_SERIALIZER = RecipeTypeRegistry.create("pot_cooking", CookingPotRecipe.Serializer::new);
    public static final RegistrySupplier<RecipeSerializer<CraftingBowlRecipe>> CRAFTING_BOWL_RECIPE_SERIALIZER = RecipeTypeRegistry.create("crafting_bowl", CraftingBowlRecipe.Serializer::new);
    public static final RegistrySupplier<RecipeSerializer<StoveRecipe>> STOVE_RECIPE_SERIALIZER = RecipeTypeRegistry.create("stove", StoveRecipe.Serializer::new);
    public static final RegistrySupplier<RecipeSerializer<MincerRecipe>> MINCER_RECIPE_SERIALIZER = RecipeTypeRegistry.create("mincer", MincerRecipe.Serializer::new);
    public static final RegistrySupplier<RecipeSerializer<RoasterRecipe>> ROASTER_RECIPE_SERIALIZER = RecipeTypeRegistry.create("roaster", RoasterRecipe.Serializer::new);
    public static final RegistrySupplier<RecipeSerializer<SiloRecipe>> SILO_RECIPE_SERIALIZER = RecipeTypeRegistry.create("drying", SiloRecipe.Serializer::new);

    private static <T extends Recipe<?>> RegistrySupplier<RecipeSerializer<T>> create(String name, Supplier<RecipeSerializer<T>> serializer) {
        return RECIPE_SERIALIZERS.register((ResourceLocation)new FarmAndCharmIdentifier(name), serializer);
    }

    private static <T extends Recipe<?>> RegistrySupplier<RecipeType<T>> create(final String name) {
        Supplier<RecipeType> type = () -> new RecipeType<T>(){

            public String toString() {
                return name;
            }
        };
        return RECIPE_TYPES.register((ResourceLocation)new FarmAndCharmIdentifier(name), type);
    }

    public static void init() {
    }
}

