/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.farm_and_charm.core.util;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.satisfy.farm_and_charm.core.entity.AbstractTowableEntity;

public final class CartWheel {
    private float rotation;
    private float rotationIncrement;
    private final float offsetX;
    private final float offsetZ;
    private final float circumference;
    private double posX;
    private double posZ;
    private double prevPosX;
    private double prevPosZ;
    private final AbstractTowableEntity cart;

    public CartWheel(AbstractTowableEntity cartIn, float offsetXIn, float offsetZIn, float circumferenceIn) {
        this.cart = cartIn;
        this.offsetX = offsetXIn;
        this.offsetZ = offsetZIn;
        this.circumference = circumferenceIn;
        this.posX = this.prevPosX = cartIn.m_20185_();
        this.posZ = this.prevPosZ = cartIn.m_20189_();
    }

    public CartWheel(AbstractTowableEntity cartIn, float offsetX) {
        this(cartIn, offsetX, 0.0f, 3.9269907f);
    }

    public void tick() {
        this.rotation += this.rotationIncrement;
        this.prevPosX = this.posX;
        this.prevPosZ = this.posZ;
        float yaw = (float)Math.toRadians(this.cart.m_146908_());
        float nx = -Mth.m_14031_((float)yaw);
        float nz = Mth.m_14089_((float)yaw);
        this.posX = this.cart.m_20185_() + (double)(nx * this.offsetZ) - (double)(nz * this.offsetX);
        this.posZ = this.cart.m_20189_() + (double)(nz * this.offsetZ) + (double)(nx * this.offsetX);
        double dx = this.posX - this.prevPosX;
        double dz = this.posZ - this.prevPosZ;
        float distanceTravelled = (float)Math.sqrt(dx * dx + dz * dz);
        double dxNormalized = dx / (double)distanceTravelled;
        double dzNormalized = dz / (double)distanceTravelled;
        float travelledForward = Mth.m_14205_((double)(dxNormalized * (double)nx + dzNormalized * (double)nz));
        if ((double)distanceTravelled > 0.2) {
            BlockPos blockpos = new BlockPos(Mth.m_14107_((double)this.posX), Mth.m_14107_((double)(this.cart.m_20186_() - (double)0.2f)), Mth.m_14107_((double)this.posZ));
            BlockState blockstate = this.cart.m_9236_().m_8055_(blockpos);
            if (blockstate.m_60799_() != RenderShape.INVISIBLE) {
                int particleCount = 15;
                float zFactor = 0.5f;
                for (int i = 0; i < particleCount; ++i) {
                    double adjustedPosZ = Mth.m_14139_((double)zFactor, (double)this.cart.m_20189_(), (double)this.posZ) + (Math.random() - 0.5) * 0.1;
                    double offsetX = this.posX + (Math.random() - 0.5) * 0.1;
                    this.cart.m_9236_().m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, blockstate), offsetX, this.cart.m_20186_() + (Math.random() - 0.5) * 0.1, adjustedPosZ, dx, (double)distanceTravelled, dz);
                }
            }
        }
        this.rotationIncrement = travelledForward * distanceTravelled * this.circumference * 0.2f;
    }

    public float getRotation() {
        return this.rotation;
    }
}

