/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.client;

import com.mrcrayfish.backpacked.Backpacked;
import com.mrcrayfish.backpacked.client.ForgeDebugClientEvents;
import com.mrcrayfish.backpacked.client.gui.screen.inventory.BackpackScreen;
import com.mrcrayfish.backpacked.client.renderer.entity.layers.BackpackLayer;
import com.mrcrayfish.backpacked.client.renderer.entity.layers.ShelfRenderer;
import com.mrcrayfish.backpacked.client.renderer.entity.layers.VillagerBackpackLayer;
import com.mrcrayfish.backpacked.common.backpack.loader.ModelMetaLoader;
import com.mrcrayfish.backpacked.core.ModBlockEntities;
import com.mrcrayfish.backpacked.core.ModContainers;
import com.mrcrayfish.backpacked.integration.Controllable;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.WanderingTraderRenderer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.loading.FMLLoader;

public class ClientHandler {
    public static void init() {
        MenuScreens.m_96206_((MenuType)((MenuType)ModContainers.BACKPACK.get()), BackpackScreen::new);
        if (Backpacked.isControllableLoaded()) {
            Controllable.init();
        }
        if (!FMLLoader.isProduction()) {
            MinecraftForge.EVENT_BUS.register((Object)new ForgeDebugClientEvents());
        }
    }

    public static void onRegisterClientLoaders(RegisterClientReloadListenersEvent event) {
        event.registerReloadListener((PreparableReloadListener)new ModelMetaLoader());
    }

    public static void onRegisterRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer((BlockEntityType)ModBlockEntities.SHELF.get(), ShelfRenderer::new);
    }

    public static void onAddLayers(EntityRenderersEvent.AddLayers event) {
        ClientHandler.addBackpackLayer(event.getSkin("default"), event.getContext().m_174025_());
        ClientHandler.addBackpackLayer(event.getSkin("slim"), event.getContext().m_174025_());
        LivingEntityRenderer renderer = event.getRenderer(EntityType.f_20494_);
        if (renderer instanceof WanderingTraderRenderer) {
            WanderingTraderRenderer traderRenderer = (WanderingTraderRenderer)renderer;
            traderRenderer.m_115326_(new VillagerBackpackLayer(traderRenderer, event.getContext().m_174025_()));
        }
    }

    private static void addBackpackLayer(EntityRenderer<?> renderer, ItemRenderer itemRenderer) {
        if (renderer instanceof PlayerRenderer) {
            PlayerRenderer playerRenderer = (PlayerRenderer)renderer;
            playerRenderer.m_115326_(new BackpackLayer(playerRenderer, itemRenderer));
        }
    }
}

