/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.data.pickpocket;

import com.mrcrayfish.backpacked.core.ModSyncedDataKeys;
import com.mrcrayfish.backpacked.util.Serializable;
import com.mrcrayfish.framework.api.sync.IDataSerializer;
import com.mrcrayfish.framework.api.sync.SyncedObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.WanderingTrader;
import net.minecraft.world.entity.player.Player;

public class TraderPickpocketing
extends SyncedObject
implements Serializable {
    public static final IDataSerializer<TraderPickpocketing> SERIALIZER = new Serializer();
    private boolean initialized = false;
    private boolean backpack = false;
    private boolean spawnedLoot = false;
    private final Map<Player, Long> detectedPlayers = new HashMap<Player, Long>();
    private final Map<UUID, Long> dislikedPlayers = new HashMap<UUID, Long>();

    public boolean isInitialized() {
        return this.initialized;
    }

    public void setInitialized() {
        this.initialized = true;
        this.markDirty();
    }

    public void setBackpackEquipped(boolean equipped) {
        this.backpack = equipped;
        this.markDirty();
    }

    public boolean isBackpackEquipped() {
        return this.backpack;
    }

    public boolean isLootSpawned() {
        return this.spawnedLoot;
    }

    public void setLootSpawned() {
        this.spawnedLoot = true;
        this.markDirty();
    }

    public Map<Player, Long> getDetectedPlayers() {
        return this.detectedPlayers;
    }

    public boolean isDislikedPlayer(Player player) {
        return this.dislikedPlayers.containsKey(player.m_20148_());
    }

    public void addDislikedPlayer(Player player, long time) {
        this.dislikedPlayers.put(player.m_20148_(), time);
    }

    public Map<UUID, Long> getDislikedPlayers() {
        return this.dislikedPlayers;
    }

    @Override
    public CompoundTag serialize() {
        CompoundTag tag = new CompoundTag();
        tag.m_128379_("Initialized", this.initialized);
        tag.m_128379_("EquippedBackpack", this.backpack);
        tag.m_128379_("SpawnedLoot", this.spawnedLoot);
        return tag;
    }

    @Override
    public void deserialize(CompoundTag tag) {
        this.initialized = tag.m_128471_("Initialized");
        this.backpack = tag.m_128471_("EquippedBackpack");
        this.spawnedLoot = tag.m_128471_("SpawnedLoot");
    }

    public static Optional<TraderPickpocketing> get(Entity entity) {
        if (entity instanceof WanderingTrader) {
            WanderingTrader trader = (WanderingTrader)entity;
            return Optional.ofNullable((TraderPickpocketing)ModSyncedDataKeys.TRADER_PICKPOCKETING.getValue((Entity)trader));
        }
        return Optional.empty();
    }

    private static class Serializer
    implements IDataSerializer<TraderPickpocketing> {
        private Serializer() {
        }

        public void write(FriendlyByteBuf buf, TraderPickpocketing value) {
            buf.writeBoolean(value.initialized);
            buf.writeBoolean(value.backpack);
            buf.writeBoolean(value.spawnedLoot);
        }

        public TraderPickpocketing read(FriendlyByteBuf buf) {
            TraderPickpocketing challenge = new TraderPickpocketing();
            challenge.initialized = buf.readBoolean();
            challenge.backpack = buf.readBoolean();
            challenge.spawnedLoot = buf.readBoolean();
            return challenge;
        }

        public Tag write(TraderPickpocketing value) {
            CompoundTag tag = new CompoundTag();
            tag.m_128379_("Initialized", value.initialized);
            tag.m_128379_("EquippedBackpack", value.backpack);
            tag.m_128379_("SpawnedLoot", value.spawnedLoot);
            return tag;
        }

        public TraderPickpocketing read(Tag nbt) {
            TraderPickpocketing challenge = new TraderPickpocketing();
            if (nbt instanceof CompoundTag) {
                CompoundTag tag = (CompoundTag)nbt;
                challenge.initialized = tag.m_128471_("Initialized");
                challenge.backpack = tag.m_128471_("EquippedBackpack");
                challenge.spawnedLoot = tag.m_128471_("SpawnedLoot");
            }
            return challenge;
        }
    }
}

