/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.item;

import com.mrcrayfish.backpacked.Config;
import com.mrcrayfish.backpacked.inventory.BackpackInventory;
import com.mrcrayfish.backpacked.inventory.BackpackedInventoryAccess;
import com.mrcrayfish.backpacked.platform.Services;
import com.mrcrayfish.backpacked.util.ClientUtils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class BackpackItem
extends Item {
    public static final Component BACKPACK_TRANSLATION = Component.m_237115_((String)"container.backpack");
    public static final MutableComponent REMOVE_ITEMS_TOOLTIP = Component.m_237115_((String)"backpacked.tooltip.remove_items").m_130940_(ChatFormatting.RED);

    public BackpackItem(Item.Properties properties) {
        super(properties);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> list, TooltipFlag flag) {
        if (level != null) {
            ClientUtils.createBackpackTooltip(stack, list);
        }
    }

    public static boolean openBackpack(ServerPlayer ownerPlayer, ServerPlayer openingPlayer) {
        ItemStack backpack = Services.BACKPACK.getBackpackStack((Player)ownerPlayer);
        if (!backpack.m_41619_()) {
            BackpackInventory backpackInventory = ((BackpackedInventoryAccess)ownerPlayer).backpacked$GetBackpackInventory();
            if (backpackInventory == null) {
                return false;
            }
            BackpackItem backpackItem = (BackpackItem)backpack.m_41720_();
            Component title = backpack.m_41788_() ? backpack.m_41786_() : BACKPACK_TRANSLATION;
            int cols = backpackItem.getColumnCount();
            int rows = backpackItem.getRowCount();
            boolean owner = ownerPlayer.equals((Object)openingPlayer);
            Services.BACKPACK.openBackpackScreen(openingPlayer, (Container)backpackInventory, cols, rows, owner, title);
            return true;
        }
        return false;
    }

    public int getColumnCount() {
        return (Integer)Config.SERVER.backpack.inventorySizeColumns.get();
    }

    public int getRowCount() {
        return (Integer)Config.SERVER.backpack.inventorySizeRows.get();
    }

    public boolean m_142095_() {
        return false;
    }
}

