/*
 * Decompiled with CFR 0.152.
 */
package com.hlysine.create_power_loader.content;

import com.hlysine.create_power_loader.content.AbstractChunkLoaderBlockEntity;
import com.hlysine.create_power_loader.content.LoaderType;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.kinetics.base.DirectionalKineticBlock;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.content.trains.station.StationBlockEntity;
import com.simibubi.create.foundation.utility.Iterate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractChunkLoaderBlock
extends DirectionalKineticBlock {
    public static final BooleanProperty ATTACHED = BlockStateProperties.f_61386_;
    public final LoaderType loaderType;

    public AbstractChunkLoaderBlock(BlockBehaviour.Properties properties, LoaderType loaderType) {
        super(properties);
        this.loaderType = loaderType;
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)ATTACHED, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.m_7926_(pBuilder.m_61104_(new Property[]{ATTACHED}));
    }

    protected boolean shouldAttach(LevelAccessor level, BlockPos pos, BlockState state) {
        return level.m_8055_(pos.m_121945_(((Direction)state.m_61143_((Property)FACING)).m_122424_())).m_60713_((Block)AllBlocks.TRACK_STATION.get());
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState state = super.m_5573_(context);
        if (state == null) {
            return null;
        }
        for (Direction direction : Iterate.directions) {
            if (!context.m_43725_().m_8055_(context.m_8083_().m_121945_(direction)).m_60713_((Block)AllBlocks.TRACK_STATION.get())) continue;
            state = (BlockState)state.m_61124_((Property)FACING, (Comparable)direction.m_122424_());
            break;
        }
        if (this.shouldAttach((LevelAccessor)context.m_43725_(), context.m_8083_(), state)) {
            state = (BlockState)state.m_61124_((Property)ATTACHED, (Comparable)Boolean.valueOf(true));
        }
        return state;
    }

    private void updateBEStation(LevelAccessor level, BlockPos pos, BlockState state) {
        BlockEntity be = level.m_7702_(pos);
        if (!(be instanceof AbstractChunkLoaderBlockEntity)) {
            return;
        }
        AbstractChunkLoaderBlockEntity clbe = (AbstractChunkLoaderBlockEntity)be;
        if (!((Boolean)state.m_61143_((Property)ATTACHED)).booleanValue()) {
            clbe.updateAttachedStation(null);
            return;
        }
        BlockEntity station = level.m_7702_(pos.m_121945_(((Direction)state.m_61143_((Property)FACING)).m_122424_()));
        if (!(station instanceof StationBlockEntity)) {
            return;
        }
        StationBlockEntity sbe = (StationBlockEntity)station;
        clbe.updateAttachedStation(sbe);
    }

    public void m_6861_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Block block, @NotNull BlockPos fromPos, boolean isMoving) {
        boolean shouldAttach;
        if (level.f_46443_) {
            return;
        }
        boolean attached = (Boolean)state.m_61143_((Property)ATTACHED);
        if (attached == (shouldAttach = this.shouldAttach((LevelAccessor)level, pos, state))) {
            return;
        }
        BlockState newState = (BlockState)state.m_61122_((Property)ATTACHED);
        level.m_46597_(pos, newState);
        this.updateBEStation((LevelAccessor)level, pos, newState);
    }

    @NotNull
    public BlockState m_7417_(@NotNull BlockState pState, @NotNull Direction pDirection, @NotNull BlockState pNeighborState, @NotNull LevelAccessor pLevel, @NotNull BlockPos pCurrentPos, @NotNull BlockPos pNeighborPos) {
        BlockState state = super.m_7417_(pState, pDirection, pNeighborState, pLevel, pCurrentPos, pNeighborPos);
        BlockState newState = (BlockState)state.m_61124_((Property)ATTACHED, (Comparable)Boolean.valueOf(this.shouldAttach(pLevel, pCurrentPos, state)));
        this.updateBEStation(pLevel, pCurrentPos, newState);
        return newState;
    }

    public Direction.Axis getRotationAxis(BlockState state) {
        return ((Direction)state.m_61143_((Property)FACING)).m_122434_();
    }

    public boolean hasShaftTowards(LevelReader world, BlockPos pos, BlockState state, Direction face) {
        return (Boolean)state.m_61143_((Property)ATTACHED) == false && face == ((Direction)state.m_61143_((Property)FACING)).m_122424_();
    }

    public IRotate.SpeedLevel getMinimumRequiredSpeedLevel() {
        return IRotate.SpeedLevel.MEDIUM;
    }

    public boolean m_7278_(@NotNull BlockState pState) {
        return true;
    }

    public int m_6782_(@NotNull BlockState pState, @NotNull Level pLevel, @NotNull BlockPos pPos) {
        BlockEntity be = pLevel.m_7702_(pPos);
        if (be instanceof AbstractChunkLoaderBlockEntity) {
            AbstractChunkLoaderBlockEntity chunkLoader = (AbstractChunkLoaderBlockEntity)be;
            boolean attached = (Boolean)pState.m_61143_((Property)ATTACHED);
            return (attached ? chunkLoader.isLoaderActive : chunkLoader.canLoadChunks()) ? 15 : 0;
        }
        return 0;
    }
}

