/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.compat.jei;

import com.mrh0.createaddition.compat.jei.CARecipeCategory;
import com.mrh0.createaddition.index.CAItems;
import com.mrh0.createaddition.recipe.liquid_burning.LiquidBurningRecipe;
import com.mrh0.createaddition.util.ClientMinecraftWrapper;
import com.simibubi.create.compat.jei.category.CreateRecipeCategory;
import com.simibubi.create.compat.jei.category.animations.AnimatedBlazeBurner;
import com.simibubi.create.content.processing.recipe.HeatCondition;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.utility.Lang;
import java.util.List;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class LiquidBurningCategory
extends CARecipeCategory<LiquidBurningRecipe> {
    private final AnimatedBlazeBurner heater = new AnimatedBlazeBurner();

    public LiquidBurningCategory(CreateRecipeCategory.Info<LiquidBurningRecipe> info) {
        super(info);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, LiquidBurningRecipe recipe, IFocusGroup focuses) {
        List<ItemStack> buckets = recipe.getFluidIngredient().getMatchingFluidStacks().stream().filter(e -> e != null).map(e -> new ItemStack((ItemLike)e.getFluid().m_6859_())).toList();
        builder.addSlot(RecipeIngredientRole.INPUT, this.getBackground().getWidth() / 2 - 56, 3).setBackground(LiquidBurningCategory.getRenderedSlot(), -1, -1).addItemStack(new ItemStack((ItemLike)CAItems.STRAW.get()));
        builder.addSlot(RecipeIngredientRole.INPUT, this.getBackground().getWidth() / 2 - 36, 3).setBackground(LiquidBurningCategory.getRenderedSlot(), -1, -1).addItemStacks(buckets);
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, this.getBackground().getWidth() / 2 - 16, 3).setBackground(LiquidBurningCategory.getRenderedSlot(), -1, -1).addIngredients((IIngredientType)ForgeTypes.FLUID_STACK, LiquidBurningCategory.withImprovedVisibility((List)recipe.getFluidIngredient().getMatchingFluidStacks()))).addTooltipCallback(LiquidBurningCategory.addFluidTooltip((int)recipe.getFluidIngredient().getRequiredAmount()));
    }

    public void draw(LiquidBurningRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics gg, double mouseX, double mouseY) {
        gg.m_280488_(ClientMinecraftWrapper.getFont(), LiquidBurningCategory.formatTime(recipe.getBurnTime()), this.getBackground().getWidth() / 2 + 48, 36, 0x404040);
        HeatCondition requiredHeat = recipe.isSuperheated() ? HeatCondition.SUPERHEATED : HeatCondition.HEATED;
        AllGuiTextures.JEI_LIGHT.render(gg, 81, 38);
        AllGuiTextures.JEI_HEAT_BAR.render(gg, 4, 30);
        gg.m_280430_(ClientMinecraftWrapper.getFont(), (Component)Lang.translateDirect((String)requiredHeat.getTranslationKey(), (Object[])new Object[0]), 9, 36, requiredHeat.getColor());
        this.heater.withHeat(requiredHeat.visualizeAsBlazeBurner()).draw(gg, this.getBackground().getWidth() / 2 + 3, 5);
        AllGuiTextures.JEI_DOWN_ARROW.render(gg, this.getBackground().getWidth() / 2 + 3, 8);
    }

    public static String formatTime(int ticks) {
        if (ticks > 1200) {
            return ticks / 1200 + " min";
        }
        if (ticks > 20) {
            return ticks / 20 + " sec";
        }
        return ticks + " ticks";
    }
}

