/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.herbalbrews.client.gui.handler;

import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PotionItem;
import net.satisfy.herbalbrews.core.registry.ObjectRegistry;
import net.satisfy.herbalbrews.core.registry.ScreenHandlerTypeRegistry;
import org.jetbrains.annotations.NotNull;

public class CauldronGuiHandler
extends AbstractContainerMenu {
    private final Container container;
    private final ContainerData data;

    public CauldronGuiHandler(int syncId, Inventory playerInventory) {
        this(syncId, playerInventory, (Container)new SimpleContainer(5), (ContainerData)new SimpleContainerData(2));
    }

    public CauldronGuiHandler(int syncId, Inventory playerInventory, Container container, ContainerData data) {
        super((MenuType)ScreenHandlerTypeRegistry.CAULDRON_SCREEN_HANDLER.get(), syncId);
        int i;
        this.container = container;
        this.data = data;
        this.m_38884_(this.data);
        this.m_38897_(new Slot(container, 0, 57, 16){

            public boolean m_5857_(ItemStack stack) {
                return stack.m_41720_() instanceof PotionItem;
            }
        });
        this.m_38897_(new Slot(container, 1, 79, 22){

            public boolean m_5857_(ItemStack stack) {
                return stack.m_41720_() instanceof PotionItem;
            }
        });
        this.m_38897_(new Slot(container, 2, 101, 16){

            public boolean m_5857_(ItemStack stack) {
                return stack.m_41720_() instanceof PotionItem;
            }
        });
        this.m_38897_(new Slot(container, 3, 79, 58){

            public boolean m_5857_(ItemStack stack) {
                return false;
            }
        });
        this.m_38897_(new Slot(container, 4, 148, 42){

            public boolean m_5857_(ItemStack stack) {
                return stack.m_41720_() == ObjectRegistry.HERBAL_INFUSION.get();
            }
        });
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)playerInventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)playerInventory, i, 8 + i * 18, 142));
        }
    }

    public int getScaledProgress(int maxHeight) {
        int progress = this.data.m_6413_(0);
        int total = this.data.m_6413_(1);
        if (progress == 0 || total == 0) {
            return 0;
        }
        return progress * maxHeight / total;
    }

    @NotNull
    public ItemStack m_7648_(Player player, int index) {
        ItemStack stack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot.m_6657_()) {
            ItemStack originalStack = slot.m_7993_();
            stack = originalStack.m_41777_();
            if (index < 5) {
                if (!this.m_38903_(originalStack, 5, this.f_38839_.size(), true)) {
                    return ItemStack.f_41583_;
                }
            } else if (originalStack.m_41720_() == ObjectRegistry.HERBAL_INFUSION.get()) {
                if (!this.m_38903_(originalStack, 4, 5, false)) {
                    return ItemStack.f_41583_;
                }
            } else {
                for (int i = 0; i < 3; ++i) {
                    Slot inputSlot = (Slot)this.f_38839_.get(i);
                    if (inputSlot.m_6657_() || this.m_38903_(originalStack, i, i + 1, false)) continue;
                    return ItemStack.f_41583_;
                }
            }
            if (originalStack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return stack;
    }

    public int getCookingTime() {
        return this.data.m_6413_(0);
    }

    public int getRequiredDuration() {
        return this.data.m_6413_(1);
    }

    public boolean m_6875_(Player player) {
        return this.container.m_6542_(player);
    }
}

