/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.herbalbrews.core.blocks.entity;

import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.satisfy.herbalbrews.client.gui.handler.TeaKettleGuiHandler;
import net.satisfy.herbalbrews.core.blocks.TeaKettleBlock;
import net.satisfy.herbalbrews.core.recipe.TeaKettleRecipe;
import net.satisfy.herbalbrews.core.registry.EntityTypeRegistry;
import net.satisfy.herbalbrews.core.registry.RecipeTypeRegistry;
import net.satisfy.herbalbrews.core.registry.TagsRegistry;
import net.satisfy.herbalbrews.core.world.ImplementedInventory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TeaKettleBlockEntity
extends BlockEntity
implements ImplementedInventory,
MenuProvider {
    private final NonNullList<ItemStack> inventory = NonNullList.m_122780_((int)8, (Object)ItemStack.f_41583_);
    private static final int MAX_CAPACITY = 8;
    private static final int MAX_HEAT_LEVEL = 100;
    private static final int HEAT_CONSUMPTION_THRESHOLD = 70;
    private static final int HEAT_PER_ITEM = 35;
    private int cookingTime;
    private int requiredDuration;
    public static final int OUTPUT_SLOT = 0;
    private static final int INGREDIENTS_AREA = 5;
    private static final int WATER_SLOT = 6;
    private static final int HEATING_SLOT = 7;
    private boolean isBeingBurned = false;
    protected float experience;
    private int waterLevel;
    private int heatLevel = 0;
    private int heatDecreaseCounter = 0;
    private static final int HEAT_DECREASE_INTERVAL = 200;
    private final ContainerData delegate = new ContainerData(){

        public int m_6413_(int index) {
            return switch (index) {
                case 0 -> TeaKettleBlockEntity.this.cookingTime;
                case 1 -> {
                    if (TeaKettleBlockEntity.this.isBeingBurned) {
                        yield 1;
                    }
                    yield 0;
                }
                case 2 -> TeaKettleBlockEntity.this.waterLevel;
                case 3 -> TeaKettleBlockEntity.this.heatLevel;
                case 4 -> TeaKettleBlockEntity.this.requiredDuration;
                default -> 0;
            };
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    TeaKettleBlockEntity.this.cookingTime = value;
                    break;
                }
                case 1: {
                    TeaKettleBlockEntity.this.isBeingBurned = value != 0;
                    TeaKettleBlockEntity.this.heatLevel = TeaKettleBlockEntity.this.isBeingBurned ? 30 : 0;
                    break;
                }
                case 2: {
                    TeaKettleBlockEntity.this.waterLevel = value;
                    break;
                }
                case 3: {
                    TeaKettleBlockEntity.this.heatLevel = value;
                    break;
                }
                case 4: {
                    TeaKettleBlockEntity.this.requiredDuration = value;
                }
            }
        }

        public int m_6499_() {
            return 5;
        }
    };
    public boolean doEffect;

    public TeaKettleBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)EntityTypeRegistry.TEA_KETTLE_BLOCK_ENTITY.get(), pos, state);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        ContainerHelper.m_18980_((CompoundTag)nbt, this.inventory);
        this.cookingTime = nbt.m_128451_("CookingTime");
        this.isBeingBurned = nbt.m_128471_("IsBeingBurned");
        this.waterLevel = nbt.m_128451_("WaterLevel");
        this.heatLevel = nbt.m_128451_("HeatLevel");
        this.experience = nbt.m_128457_("Experience");
        this.requiredDuration = nbt.m_128451_("RequiredDuration");
    }

    protected void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        ContainerHelper.m_18973_((CompoundTag)nbt, this.inventory);
        nbt.m_128405_("CookingTime", this.cookingTime);
        nbt.m_128379_("IsBeingBurned", this.isBeingBurned);
        nbt.m_128405_("WaterLevel", this.waterLevel);
        nbt.m_128405_("HeatLevel", this.heatLevel);
        nbt.m_128350_("Experience", this.experience);
        nbt.m_128405_("RequiredDuration", this.requiredDuration);
    }

    public boolean isBeingBurned() {
        if (this.m_58904_() == null) {
            throw new NullPointerException("Null world invoked");
        }
        BlockState belowState = this.m_58904_().m_8055_(this.m_58899_().m_7495_());
        Optional optionalList = BuiltInRegistries.f_256975_.m_203431_(TagsRegistry.ALLOWS_COOKING);
        HolderSet.Named entryList = optionalList.orElse(null);
        if (entryList == null) {
            return false;
        }
        return entryList.m_203333_((Holder)belowState.m_60734_().m_204297_());
    }

    private boolean canCraft(TeaKettleRecipe recipe) {
        if (recipe == null || recipe.getResultItem().m_41619_()) {
            return false;
        }
        if (this.m_8020_(0).m_41619_()) {
            return this.waterLevel >= recipe.getRequiredWater() && this.heatLevel >= recipe.getRequiredHeat();
        }
        ItemStack recipeOutput = recipe.getResultItem();
        ItemStack outputSlotStack = this.m_8020_(0);
        int outputSlotCount = outputSlotStack.m_41613_();
        if (!ItemStack.m_41656_((ItemStack)outputSlotStack, (ItemStack)recipeOutput)) {
            return false;
        }
        if (outputSlotCount < this.m_6893_() && outputSlotCount < outputSlotStack.m_41741_()) {
            return this.waterLevel >= recipe.getRequiredWater() && this.heatLevel >= recipe.getRequiredHeat();
        }
        if (this.waterLevel < recipe.getRequiredWater() || this.heatLevel < recipe.getRequiredHeat()) {
            return false;
        }
        return outputSlotCount < recipeOutput.m_41741_();
    }

    private void craft(TeaKettleRecipe recipe) {
        ItemStack outputSlotStack;
        if (!this.canCraft(recipe)) {
            return;
        }
        NonNullList ingredients = NonNullList.m_122779_();
        for (int i = 1; i <= 5; ++i) {
            ingredients.add((Object)this.m_8020_(i));
        }
        for (Ingredient ingredient : recipe.m_7527_()) {
            boolean ingredientConsumed = false;
            for (int i = 0; i < ingredients.size(); ++i) {
                ItemStack inputStack = (ItemStack)ingredients.get(i);
                if (inputStack.m_41619_() || !ingredient.test(inputStack)) continue;
                ItemStack remainderStack = this.getRemainderItem(inputStack);
                inputStack.m_41774_(1);
                if (inputStack.m_41619_()) {
                    this.m_6836_(i + 1, remainderStack);
                }
                ingredientConsumed = true;
                ingredients.set(i, (Object)inputStack);
                break;
            }
            if (ingredientConsumed) continue;
            return;
        }
        ItemStack recipeOutput = recipe.assemble();
        if (recipe.getEffect() != null && recipe.getEffectDuration() > 0) {
            CompoundTag tag = recipeOutput.m_41784_();
            tag.m_128359_("Effect", Objects.requireNonNull(BuiltInRegistries.f_256974_.m_7981_((Object)recipe.getEffect())).toString());
            tag.m_128405_("EffectDuration", recipe.getEffectDuration());
            recipeOutput.m_41751_(tag);
        }
        if ((outputSlotStack = this.m_8020_(0)).m_41619_()) {
            this.m_6836_(0, recipeOutput);
        } else if (outputSlotStack.m_150930_(recipeOutput.m_41720_())) {
            outputSlotStack.m_41769_(recipeOutput.m_41613_());
        }
        this.waterLevel -= recipe.getRequiredWater();
        if (this.waterLevel < 0) {
            this.waterLevel = 0;
        }
        this.requiredDuration = recipe.getRequiredDuration();
        this.cookingTime = 0;
    }

    private ItemStack getRemainderItem(ItemStack stack) {
        if (stack.m_41720_().m_41470_()) {
            return new ItemStack((ItemLike)Objects.requireNonNull(stack.m_41720_().m_41469_()));
        }
        return ItemStack.f_41583_;
    }

    public void consumeHeatItem() {
        ItemStack heatingItem = (ItemStack)this.inventory.get(7);
        if (!heatingItem.m_41619_() && heatingItem.m_204117_(TagsRegistry.HEAT_ITEMS)) {
            heatingItem.m_41774_(1);
            this.inventory.set(7, (Object)heatingItem);
            this.doEffect = true;
            this.m_6596_();
            if (this.f_58857_ != null && !this.f_58857_.m_5776_()) {
                this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
            }
        }
    }

    @NotNull
    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        tag.m_128379_("DoEffect", this.doEffect);
        return tag;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void tick(Level world, BlockPos pos, BlockState state) {
        TeaKettleRecipe recipe;
        boolean canCraft;
        int decreaseInterval;
        boolean currentBurned;
        if (world.m_5776_()) {
            return;
        }
        boolean previousBurned = this.isBeingBurned;
        this.isBeingBurned = currentBurned = this.isBeingBurned();
        if (!previousBurned && currentBurned) {
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)TeaKettleBlock.LIT, (Comparable)Boolean.valueOf(true)), 3);
            this.heatLevel = Math.max(this.heatLevel, 30);
        } else if (previousBurned && !currentBurned) {
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)TeaKettleBlock.LIT, (Comparable)Boolean.valueOf(false)), 3);
            this.heatLevel = 0;
        }
        ItemStack heatingItem = this.m_8020_(7);
        if (this.heatLevel < 70 && !heatingItem.m_41619_() && heatingItem.m_204117_(TagsRegistry.HEAT_ITEMS)) {
            this.heatLevel = Math.min(this.heatLevel + 35, 100);
            this.consumeHeatItem();
            this.m_6596_();
        }
        ++this.heatDecreaseCounter;
        int n = decreaseInterval = this.isBeingBurned ? 200 : 33;
        if (this.heatDecreaseCounter >= decreaseInterval) {
            this.heatDecreaseCounter = 0;
            if (this.heatLevel > (this.isBeingBurned ? 30 : 0)) {
                this.heatLevel = Math.max(this.heatLevel - 1, this.isBeingBurned ? 30 : 0);
                this.m_6596_();
            }
        }
        if (canCraft = this.canCraft(recipe = (TeaKettleRecipe)world.m_7465_().m_44015_((RecipeType)RecipeTypeRegistry.TEA_KETTLE_RECIPE_TYPE.get(), (Container)this, world).orElse(null))) {
            if (this.requiredDuration <= 0) {
                this.requiredDuration = recipe.getRequiredDuration();
                this.cookingTime = 0;
            } else {
                ++this.cookingTime;
                if (this.cookingTime >= this.requiredDuration) {
                    this.cookingTime = 0;
                    this.craft(recipe);
                }
            }
            world.m_7731_(pos, (BlockState)((BlockState)state.m_61124_((Property)TeaKettleBlock.COOKING, (Comparable)Boolean.valueOf(true))).m_61124_((Property)TeaKettleBlock.LIT, (Comparable)Boolean.valueOf(this.isBeingBurned)), 3);
        } else {
            this.cookingTime = 0;
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)TeaKettleBlock.COOKING, (Comparable)Boolean.valueOf(false)), 3);
        }
        if (!this.m_8020_(6).m_41619_()) {
            ItemStack waterItem = this.m_8020_(6);
            if (waterItem.m_204117_(TagsRegistry.SMALL_WATER_FILL)) {
                this.waterLevel = Math.min(this.waterLevel + 25, 100);
                ItemStack remainderStack = this.getRemainderItem(waterItem);
                waterItem.m_41774_(1);
                this.m_6836_(6, remainderStack.m_41619_() ? ItemStack.f_41583_ : remainderStack);
                this.m_6596_();
            } else if (waterItem.m_204117_(TagsRegistry.LARGE_WATER_FILL)) {
                this.waterLevel = Math.min(this.waterLevel + 50, 100);
                ItemStack remainderStack = this.getRemainderItem(waterItem);
                waterItem.m_41774_(1);
                this.m_6836_(6, remainderStack.m_41619_() ? ItemStack.f_41583_ : remainderStack);
                this.m_6596_();
            }
        }
        this.delegate.m_8050_(3, this.heatLevel);
        this.delegate.m_8050_(4, this.requiredDuration);
    }

    @Override
    public NonNullList<ItemStack> getItems() {
        return this.inventory;
    }

    public int getWaterLevel() {
        return this.waterLevel;
    }

    public int getHeatLevel() {
        return this.heatLevel;
    }

    @Override
    public boolean m_6542_(Player player) {
        if (this.f_58857_ == null) {
            return false;
        }
        if (this.f_58857_.m_7702_(this.f_58858_) != this) {
            return false;
        }
        return player.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) <= 64.0;
    }

    public void dropExperience(ServerLevel world, Vec3 pos) {
        ExperienceOrb.m_147082_((ServerLevel)world, (Vec3)pos, (int)((int)this.experience));
    }

    @NotNull
    public Component m_5446_() {
        return Component.m_237115_((String)this.m_58900_().m_60734_().m_7705_());
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int syncId, Inventory inv, Player player) {
        return new TeaKettleGuiHandler(syncId, inv, (Container)this, this.delegate);
    }

    @Override
    public int @NotNull [] m_7071_(Direction side) {
        if (side == Direction.DOWN) {
            return new int[]{0, 6};
        }
        return new int[]{1, 2, 3, 4, 5, 6, 7};
    }

    @Override
    public boolean m_7155_(int index, ItemStack stack, Direction direction) {
        if (direction == Direction.DOWN) {
            return false;
        }
        if (stack.m_204117_(TagsRegistry.CONTAINER_ITEMS)) {
            return index == 5;
        }
        if (stack.m_204117_(TagsRegistry.HEAT_ITEMS)) {
            return index == 7;
        }
        if (stack.m_204117_(TagsRegistry.SMALL_WATER_FILL) || stack.m_204117_(TagsRegistry.LARGE_WATER_FILL)) {
            return index == 6;
        }
        return index >= 1 && index <= 4;
    }

    @Override
    public boolean m_7157_(int index, ItemStack stack, Direction direction) {
        return index == 0 || index == 6;
    }
}

