/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.herbalbrews.core.items;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DrinkBlockItem
extends BlockItem {
    public DrinkBlockItem(Block block, Item.Properties settings) {
        super(block, settings.m_41487_(16));
    }

    @NotNull
    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.DRINK;
    }

    @NotNull
    public ItemStack m_5922_(ItemStack stack, Level world, LivingEntity user) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128441_("Effect") && tag.m_128441_("EffectDuration")) {
            ResourceLocation effectId = new ResourceLocation(tag.m_128461_("Effect"));
            MobEffect effect = (MobEffect)BuiltInRegistries.f_256974_.m_7745_(effectId);
            int duration = tag.m_128451_("EffectDuration");
            if (effect != null) {
                user.m_7292_(new MobEffectInstance(effect, duration));
            }
        }
        ArrayList effects = this.m_41473_() != null ? this.m_41473_().m_38749_() : Lists.newArrayList();
        for (Pair effectPair : effects) {
            if (!(world.f_46441_.m_188501_() < ((Float)effectPair.getSecond()).floatValue())) continue;
            user.m_7292_(new MobEffectInstance((MobEffectInstance)effectPair.getFirst()));
        }
        return super.m_5922_(stack, world, user);
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag context) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128441_("Effect") && tag.m_128441_("EffectDuration")) {
            ResourceLocation effectId = new ResourceLocation(tag.m_128461_("Effect"));
            MobEffect effect = (MobEffect)BuiltInRegistries.f_256974_.m_7745_(effectId);
            int duration = tag.m_128451_("EffectDuration");
            if (effect != null) {
                MobEffectInstance effectInstance = new MobEffectInstance(effect, duration);
                MutableComponent effectName = Component.m_237115_((String)effect.m_19481_());
                if (effectInstance.m_19557_() > 20) {
                    effectName = Component.m_237110_((String)"potion.withDuration", (Object[])new Object[]{effectName, MobEffectUtil.m_267641_((MobEffectInstance)effectInstance, (float)1.0f)});
                }
                tooltip.add((Component)effectName.m_130940_(effect.m_19483_().m_19497_()));
            }
        } else {
            tooltip.add((Component)Component.m_237115_((String)"effect.none").m_130940_(ChatFormatting.GRAY));
        }
        ArrayList attributeModifiers = Lists.newArrayList();
        if (tag != null && tag.m_128441_("AttributeModifiers")) {
            ListTag modifiers = tag.m_128437_("AttributeModifiers", 10);
            for (int i = 0; i < modifiers.size(); ++i) {
                CompoundTag modifierTag = modifiers.m_128728_(i);
                String attributeName = modifierTag.m_128461_("AttributeName");
                Attribute attribute = (Attribute)BuiltInRegistries.f_256951_.m_7745_(new ResourceLocation(attributeName));
                if (attribute == null) continue;
                AttributeModifier.Operation operation = AttributeModifier.Operation.values()[modifierTag.m_128445_("Operation")];
                double amount = modifierTag.m_128459_("Amount");
                UUID uuid = UUID.fromString(modifierTag.m_128461_("UUID"));
                AttributeModifier modifier = new AttributeModifier(uuid, modifierTag.m_128461_("Name"), amount, operation);
                attributeModifiers.add(new Pair((Object)attribute, (Object)modifier));
            }
        }
        if (!attributeModifiers.isEmpty()) {
            tooltip.add((Component)Component.m_237119_());
            tooltip.add((Component)Component.m_237115_((String)"potion.whenDrank").m_130940_(ChatFormatting.DARK_PURPLE));
            for (Pair pair : attributeModifiers) {
                double displayAmount;
                AttributeModifier modifier = (AttributeModifier)pair.getSecond();
                double amount = modifier.m_22218_();
                double d = displayAmount = modifier.m_22217_() == AttributeModifier.Operation.MULTIPLY_BASE || modifier.m_22217_() == AttributeModifier.Operation.MULTIPLY_TOTAL ? amount * 100.0 : amount;
                if (amount > 0.0) {
                    tooltip.add((Component)Component.m_237110_((String)("attribute.modifier.plus." + modifier.m_22217_().m_22235_()), (Object[])new Object[]{ItemStack.f_41584_.format(displayAmount), Component.m_237115_((String)((Attribute)pair.getFirst()).m_22087_())}).m_130940_(ChatFormatting.BLUE));
                    continue;
                }
                if (!(amount < 0.0)) continue;
                tooltip.add((Component)Component.m_237110_((String)("attribute.modifier.take." + modifier.m_22217_().m_22235_()), (Object[])new Object[]{ItemStack.f_41584_.format(-displayAmount), Component.m_237115_((String)((Attribute)pair.getFirst()).m_22087_())}).m_130940_(ChatFormatting.RED));
            }
        }
        tooltip.add((Component)Component.m_237115_((String)"tooltip.herbalbrews.canbeplaced").m_130938_(style -> style.m_131148_(TextColor.m_131266_((int)13467442)).m_131155_(Boolean.valueOf(true))));
    }
}

