/*
 * Decompiled with CFR 0.152.
 */
package systems.alexander.bellsandwhistles.block.custom;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FaceAttachedHorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class HeadlightBlock
extends FaceAttachedHorizontalDirectionalBlock {
    private static final VoxelShape SHAPE = Shapes.m_83113_((VoxelShape)Block.m_49796_((double)4.5, (double)4.5, (double)13.0, (double)11.5, (double)11.5, (double)16.0), (VoxelShape)Block.m_49796_((double)4.0, (double)4.0, (double)14.0, (double)12.0, (double)12.0, (double)16.0), (BooleanOp)BooleanOp.f_82695_);

    public HeadlightBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_54117_, (Comparable)Direction.NORTH)).m_61124_((Property)f_53179_, (Comparable)AttachFace.WALL));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{f_54117_, f_53179_});
    }

    public float m_7749_(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        return 1.0f;
    }

    public boolean m_7420_(BlockState pState, BlockGetter pReader, BlockPos pPos) {
        return true;
    }

    public static VoxelShape rotateShape(Direction from, Direction to, VoxelShape shape) {
        VoxelShape[] buffer = new VoxelShape[]{shape, Shapes.m_83040_()};
        int times = (to.ordinal() - from.m_122416_() + 4) % 4;
        for (int i = 0; i < times; ++i) {
            buffer[0].m_83286_((minX, minY, minZ, maxX, maxY, maxZ) -> {
                buffer[1] = Shapes.m_83110_((VoxelShape)buffer[1], (VoxelShape)Shapes.m_166049_((double)(1.0 - maxZ), (double)minY, (double)minX, (double)(1.0 - minZ), (double)maxY, (double)maxX));
            });
            buffer[0] = buffer[1];
            buffer[1] = Shapes.m_83040_();
        }
        return buffer[0];
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        if (pState.m_61143_((Property)f_53179_) == AttachFace.FLOOR) {
            return Shapes.m_83113_((VoxelShape)Block.m_49796_((double)4.5, (double)0.0, (double)5.0, (double)11.5, (double)3.0, (double)12.0), (VoxelShape)Block.m_49796_((double)4.0, (double)0.0, (double)4.5, (double)12.0, (double)2.0, (double)12.5), (BooleanOp)BooleanOp.f_82695_);
        }
        if (pState.m_61143_((Property)f_53179_) == AttachFace.CEILING) {
            return Shapes.m_83113_((VoxelShape)Block.m_49796_((double)4.5, (double)13.0, (double)5.0, (double)11.5, (double)16.0, (double)12.0), (VoxelShape)Block.m_49796_((double)4.0, (double)14.0, (double)4.5, (double)12.0, (double)16.0, (double)12.5), (BooleanOp)BooleanOp.f_82695_);
        }
        switch ((Direction)pState.m_61143_((Property)f_54117_)) {
            case NORTH: {
                return SHAPE;
            }
            case SOUTH: {
                return HeadlightBlock.rotateShape(Direction.NORTH, Direction.WEST, SHAPE);
            }
            case WEST: {
                return HeadlightBlock.rotateShape(Direction.NORTH, Direction.EAST, SHAPE);
            }
        }
        return HeadlightBlock.rotateShape(Direction.NORTH, Direction.SOUTH, SHAPE);
    }
}

