/*
 * Decompiled with CFR 0.152.
 */
package glitchcore.forge.mixin.client;

import glitchcore.event.EventManager;
import glitchcore.event.client.RenderGuiEvent;
import net.minecraft.client.gui.Gui;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={VanillaGuiOverlay.class}, remap=false)
public abstract class MixinVanillaGuiOverlay {
    @Mutable
    @Final
    @Shadow
    IGuiOverlay overlay;

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void onInit(String enumName, int ordinal, String id, IGuiOverlay overlay, CallbackInfo ci) {
        this.overlay = switch (enumName) {
            case "FROSTBITE" -> MixinVanillaGuiOverlay.wrapRenderer(overlay, RenderGuiEvent.Type.FROSTBITE);
            case "FOOD_LEVEL" -> MixinVanillaGuiOverlay.wrapRenderer(overlay, RenderGuiEvent.Type.FOOD);
            case "AIR_LEVEL" -> MixinVanillaGuiOverlay.wrapRendererWithRightModification(overlay, RenderGuiEvent.Type.AIR);
            default -> overlay;
        };
    }

    @Unique
    private static IGuiOverlay wrapRenderer(IGuiOverlay original, RenderGuiEvent.Type type) {
        return (gui, guiGraphics, partialTick, screenWidth, screenHeight) -> {
            EventManager.fire(new RenderGuiEvent.Pre(type, (Gui)gui, guiGraphics, partialTick, screenWidth, screenHeight));
            original.render(gui, guiGraphics, partialTick, screenWidth, screenHeight);
        };
    }

    @Unique
    private static IGuiOverlay wrapRendererWithRightModification(IGuiOverlay original, RenderGuiEvent.Type type) {
        return (gui, guiGraphics, partialTick, screenWidth, screenHeight) -> {
            int rightTop = screenHeight - gui.rightHeight;
            RenderGuiEvent.Pre event = new RenderGuiEvent.Pre(type, (Gui)gui, guiGraphics, partialTick, screenWidth, screenHeight, rightTop);
            EventManager.fire(event);
            gui.rightHeight = screenHeight - event.getRowTop();
            original.render(gui, guiGraphics, partialTick, screenWidth, screenHeight);
        };
    }
}

