/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.api.util;

public class MathUtil {
    private static final double DEFAULT_EPSILON = 1.0E-7;

    private MathUtil() {
        throw new IllegalStateException("Can not instantiate an instance of: MathUtil. This is a utility class");
    }

    public static boolean almostEqual(Number l, Number r) {
        return MathUtil.almostEqual(l, r, 1.0E-7);
    }

    public static boolean almostEqual(Number l, Number r, Number epsilon) {
        double diff = Math.abs(l.doubleValue() - r.doubleValue());
        return diff < epsilon.doubleValue();
    }

    public static double minimizeTowardsZero(double l, double r) {
        double absR;
        double absL = Math.abs(l);
        if (absL <= (absR = Math.abs(r))) {
            return l;
        }
        return r;
    }

    public static double maximizeAwayFromZero(double l, double r) {
        double absR;
        double absL = Math.abs(l);
        if (absL >= (absR = Math.abs(r))) {
            return l;
        }
        return r;
    }

    public static double makePositive(double d) {
        while (d < 0.0) {
            d += 1.0;
        }
        return d;
    }
}

