/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.network.packets;

import mod.chiselsandbits.container.BagContainer;
import mod.chiselsandbits.network.packets.ModPacket;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;

public final class BagGuiPacket
extends ModPacket {
    private int slotNumber = -1;
    private int mouseButton = -1;
    private boolean duplicateButton = false;
    private boolean holdingShift = false;

    public BagGuiPacket(FriendlyByteBuf buffer) {
        this.readPayload(buffer);
    }

    public BagGuiPacket(int slotNumber, int mouseButton, boolean duplicateButton, boolean holdingShift) {
        this.slotNumber = slotNumber;
        this.mouseButton = mouseButton;
        this.duplicateButton = duplicateButton;
        this.holdingShift = holdingShift;
    }

    @Override
    public void server(ServerPlayer player) {
        this.doAction((Player)player);
    }

    @Override
    public void writePayload(FriendlyByteBuf buffer) {
        buffer.writeInt(this.slotNumber);
        buffer.writeInt(this.mouseButton);
        buffer.writeBoolean(this.duplicateButton);
        buffer.writeBoolean(this.holdingShift);
    }

    public void doAction(Player player) {
        AbstractContainerMenu c = player.f_36096_;
        if (c instanceof BagContainer) {
            BagContainer bc = (BagContainer)c;
            bc.handleCustomSlotAction(this.slotNumber, this.mouseButton, this.duplicateButton, this.holdingShift);
        }
    }

    @Override
    public void readPayload(FriendlyByteBuf buffer) {
        this.slotNumber = buffer.readInt();
        this.mouseButton = buffer.readInt();
        this.duplicateButton = buffer.readBoolean();
        this.holdingShift = buffer.readBoolean();
    }
}

