/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.etched.common.menu;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import gg.moonflower.etched.api.record.PlayableRecord;
import gg.moonflower.etched.api.record.TrackData;
import gg.moonflower.etched.api.sound.download.SoundDownloadSource;
import gg.moonflower.etched.api.sound.download.SoundSourceManager;
import gg.moonflower.etched.common.item.BlankMusicDiscItem;
import gg.moonflower.etched.common.item.ComplexMusicLabelItem;
import gg.moonflower.etched.common.item.EtchedMusicDiscItem;
import gg.moonflower.etched.common.item.MusicLabelItem;
import gg.moonflower.etched.common.item.SimpleMusicLabelItem;
import gg.moonflower.etched.common.network.EtchedMessages;
import gg.moonflower.etched.common.network.play.ClientboundInvalidEtchUrlPacket;
import gg.moonflower.etched.core.registry.EtchedBlocks;
import gg.moonflower.etched.core.registry.EtchedItems;
import gg.moonflower.etched.core.registry.EtchedMenus;
import gg.moonflower.etched.core.registry.EtchedSounds;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.HttpUtil;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.network.PacketDistributor;

public class EtchingMenu
extends AbstractContainerMenu {
    public static final ResourceLocation EMPTY_SLOT_MUSIC_DISC = new ResourceLocation("etched", "item/empty_etching_table_slot_music_disc");
    public static final ResourceLocation EMPTY_SLOT_MUSIC_LABEL = new ResourceLocation("etched", "item/empty_etching_table_slot_music_label");
    private static final Pattern CONTENT_TYPE_PATTERN = Pattern.compile("\\s*;\\s*");
    private static final Cache<String, CompletableFuture<TrackData[]>> DATA_CACHE = CacheBuilder.newBuilder().expireAfterWrite(15L, TimeUnit.MINUTES).build();
    private static final boolean IGNORE_CACHE = false;
    private static final Set<String> VALID_FORMATS;
    private final ContainerLevelAccess access;
    private final DataSlot labelIndex;
    private final Slot discSlot;
    private final Slot labelSlot;
    private final Slot resultSlot;
    private final Container input;
    private final Container result;
    private final Player player;
    private String url;
    private int urlId;
    private long lastSoundTime;
    private CompletableFuture<?> currentRequest;
    private int currentRequestId;

    public EtchingMenu(int id, Inventory inventory) {
        this(id, inventory, ContainerLevelAccess.f_39287_);
    }

    public EtchingMenu(int id, Inventory inventory, final ContainerLevelAccess containerLevelAccess) {
        super(EtchedMenus.ETCHING_MENU.get(), id);
        this.player = inventory.f_35978_;
        this.labelIndex = DataSlot.m_39401_();
        this.input = new SimpleContainer(2){

            public void m_6596_() {
                super.m_6596_();
                EtchingMenu.this.m_6199_((Container)this);
            }
        };
        this.result = new SimpleContainer(1){

            public void m_6596_() {
                super.m_6596_();
            }
        };
        this.access = containerLevelAccess;
        this.discSlot = this.m_38897_(new Slot(this.input, 0, 44, 43){

            public boolean m_5857_(ItemStack stack) {
                return stack.m_41720_() == EtchedItems.BLANK_MUSIC_DISC.get() || stack.m_41720_() == EtchedItems.ETCHED_MUSIC_DISC.get();
            }

            public Pair<ResourceLocation, ResourceLocation> m_7543_() {
                return Pair.of((Object)InventoryMenu.f_39692_, (Object)EMPTY_SLOT_MUSIC_DISC);
            }
        });
        this.labelSlot = this.m_38897_(new Slot(this.input, 1, 62, 43){

            public boolean m_5857_(ItemStack stack) {
                return stack.m_41720_() instanceof SimpleMusicLabelItem;
            }

            public Pair<ResourceLocation, ResourceLocation> m_7543_() {
                return Pair.of((Object)InventoryMenu.f_39692_, (Object)EMPTY_SLOT_MUSIC_LABEL);
            }
        });
        this.resultSlot = this.m_38897_(new Slot(this, this.result, 0, 116, 43){
            final /* synthetic */ EtchingMenu this$0;
            {
                this.this$0 = this$0;
                super(container, slot, x, y);
            }

            public boolean m_5857_(ItemStack stack) {
                return false;
            }

            public void m_142406_(Player player, ItemStack stack) {
                this.this$0.discSlot.m_6201_(1);
                this.this$0.labelSlot.m_6201_(1);
                if (!this.this$0.discSlot.m_6657_() || !this.this$0.labelSlot.m_6657_()) {
                    this.this$0.labelIndex.m_6422_(0);
                }
                this.this$0.setupResultSlot();
                this.this$0.m_38946_();
                containerLevelAccess.m_39292_((level, pos) -> {
                    long l = level.m_46467_();
                    if (this.this$0.lastSoundTime != l) {
                        level.m_5594_(null, pos, EtchedSounds.UI_ETCHER_TAKE_RESULT.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                        this.this$0.lastSoundTime = l;
                    }
                });
                super.m_142406_(player, stack);
            }
        });
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.m_38897_(new Slot((Container)inventory, x + y * 9 + 9, 8 + x * 18, 98 + y * 18));
            }
        }
        for (int x = 0; x < 9; ++x) {
            this.m_38897_(new Slot((Container)inventory, x, 8 + x * 18, 156));
        }
        this.m_38895_(this.labelIndex);
    }

    private static void checkStatus(String url) throws IOException {
        URL uri = new URL(url);
        HttpURLConnection httpURLConnection = (HttpURLConnection)uri.openConnection(Proxy.NO_PROXY);
        if (!uri.getHost().equals("www.dropbox.com")) {
            httpURLConnection.setRequestMethod("HEAD");
        }
        httpURLConnection.setInstanceFollowRedirects(true);
        Map<String, String> map = SoundDownloadSource.getDownloadHeaders();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            httpURLConnection.setRequestProperty(entry.getKey(), entry.getValue());
        }
        if (httpURLConnection.getResponseCode() != 200) {
            throw new IOException(httpURLConnection.getResponseCode() + " " + httpURLConnection.getResponseMessage());
        }
        String contentType = httpURLConnection.getContentType();
        if (!VALID_FORMATS.contains(CONTENT_TYPE_PATTERN.split(contentType.toLowerCase(Locale.ROOT))[0])) {
            throw new IOException("Unsupported Content-Type: " + contentType);
        }
    }

    public void m_6877_(Player player) {
        super.m_6877_(player);
        this.access.m_39292_((level, pos) -> this.m_150411_(player, this.input));
    }

    public boolean m_6875_(Player player) {
        return EtchingMenu.m_38889_((ContainerLevelAccess)this.access, (Player)player, (Block)((Block)EtchedBlocks.ETCHING_TABLE.get()));
    }

    public boolean m_6366_(Player player, int index) {
        if (index >= 0 && index < EtchedMusicDiscItem.LabelPattern.values().length) {
            this.labelIndex.m_6422_(index);
            this.setupResultSlot();
            return true;
        }
        return false;
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack itemStack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot.m_6657_()) {
            ItemStack itemStack2 = slot.m_7993_();
            itemStack = itemStack2.m_41777_();
            if (index < 3 ? !this.m_38903_(itemStack2, 3, this.f_38839_.size(), true) : !this.m_38903_(itemStack2, 0, 3, false)) {
                return ItemStack.f_41583_;
            }
            if (itemStack2.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (itemStack2.m_41613_() == itemStack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, itemStack2);
        }
        return itemStack;
    }

    public void m_6199_(Container container) {
        ItemStack discStack = this.discSlot.m_7993_();
        ItemStack labelStack = this.labelSlot.m_7993_();
        ItemStack resultStack = this.resultSlot.m_7993_();
        if (resultStack.m_41619_() && labelStack.m_41619_()) {
            if (!discStack.m_41619_() && discStack.m_41720_() == EtchedItems.ETCHED_MUSIC_DISC.get()) {
                this.labelIndex.m_6422_(EtchedMusicDiscItem.getPattern(discStack).ordinal());
            } else {
                this.labelIndex.m_6422_(0);
            }
        }
        this.setupResultSlot();
        super.m_6199_(container);
    }

    private void setupResultSlot() {
        Level level = this.player.m_9236_();
        if (level.m_5776_()) {
            return;
        }
        if (this.currentRequest != null && !this.currentRequest.isDone() && this.urlId == this.currentRequestId) {
            return;
        }
        EtchedMessages.PLAY.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)this.player), (Object)new ClientboundInvalidEtchUrlPacket(""));
        this.resultSlot.m_5852_(ItemStack.f_41583_);
        if (this.labelIndex.m_6501_() >= 0 && this.labelIndex.m_6501_() < EtchedMusicDiscItem.LabelPattern.values().length) {
            ItemStack discStack = this.discSlot.m_7993_();
            ItemStack labelStack = this.labelSlot.m_7993_();
            if (discStack.m_41720_() == EtchedItems.ETCHED_MUSIC_DISC.get() || !discStack.m_41619_() && !labelStack.m_41619_()) {
                if (this.url == null && !discStack.m_41619_()) {
                    this.url = PlayableRecord.getStackAlbum(discStack).map(TrackData::url).orElse(null);
                }
                if (!TrackData.isValidURL(this.url)) {
                    return;
                }
                int currentId = this.currentRequestId = this.urlId;
                this.currentRequest = ((CompletableFuture)CompletableFuture.supplyAsync(() -> {
                    ItemStack resultStack = new ItemStack((ItemLike)EtchedItems.ETCHED_MUSIC_DISC.get());
                    resultStack.m_41764_(1);
                    int discColor = 0x515151;
                    int primaryLabelColor = 0xFFFFFF;
                    int secondaryLabelColor = 0xFFFFFF;
                    TrackData[] data = new TrackData[]{TrackData.EMPTY};
                    if (discStack.m_41720_() == EtchedItems.ETCHED_MUSIC_DISC.get()) {
                        discColor = EtchedMusicDiscItem.getDiscColor(discStack);
                        primaryLabelColor = EtchedMusicDiscItem.getLabelPrimaryColor(discStack);
                        secondaryLabelColor = EtchedMusicDiscItem.getLabelSecondaryColor(discStack);
                        data = PlayableRecord.getStackMusic(discStack).orElse(data);
                    }
                    if (data.length == 1 && !labelStack.m_41619_()) {
                        data[0] = data[0].withTitle(MusicLabelItem.getTitle(labelStack)).withArtist(MusicLabelItem.getAuthor(labelStack));
                    }
                    if (SoundSourceManager.isValidUrl(this.url)) {
                        try {
                            data = (TrackData[])((CompletableFuture)DATA_CACHE.get((Object)this.url, () -> SoundSourceManager.resolveTracks(this.url, null, Proxy.NO_PROXY))).join();
                        }
                        catch (Exception e) {
                            if (!level.m_5776_()) {
                                EtchedMessages.PLAY.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)this.player), (Object)new ClientboundInvalidEtchUrlPacket(e instanceof CompletionException ? e.getCause().getMessage() : e.getMessage()));
                            }
                            if (e instanceof CompletionException) {
                                throw (CompletionException)e;
                            }
                            throw new CompletionException(e);
                        }
                    }
                    if (!TrackData.isLocalSound(this.url)) {
                        try {
                            EtchingMenu.checkStatus(this.url);
                            data = new TrackData[]{data[0].withUrl(this.url)};
                        }
                        catch (UnknownHostException e) {
                            if (!level.m_5776_()) {
                                EtchedMessages.PLAY.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)this.player), (Object)new ClientboundInvalidEtchUrlPacket("Unknown host: " + this.url));
                            }
                            throw new CompletionException("Invalid URL", e);
                        }
                        catch (Exception e) {
                            if (!level.m_5776_()) {
                                EtchedMessages.PLAY.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)this.player), (Object)new ClientboundInvalidEtchUrlPacket(e.getLocalizedMessage()));
                            }
                            throw new CompletionException("Invalid URL", e);
                        }
                    }
                    if (discStack.m_41720_() instanceof BlankMusicDiscItem) {
                        discColor = ((BlankMusicDiscItem)discStack.m_41720_()).m_41121_(discStack);
                    }
                    if (labelStack.m_41720_() instanceof MusicLabelItem) {
                        secondaryLabelColor = primaryLabelColor = MusicLabelItem.getLabelColor(labelStack);
                    } else if (labelStack.m_41720_() instanceof ComplexMusicLabelItem) {
                        primaryLabelColor = ComplexMusicLabelItem.getPrimaryColor(labelStack);
                        secondaryLabelColor = ComplexMusicLabelItem.getSecondaryColor(labelStack);
                    }
                    for (int i = 0; i < data.length; ++i) {
                        TrackData trackData = data[i];
                        if (trackData.artist().equals(TrackData.EMPTY.artist())) {
                            trackData = trackData.withArtist(MusicLabelItem.getAuthor(labelStack));
                        }
                        if (TrackData.isLocalSound(this.url)) {
                            trackData = trackData.withUrl(new ResourceLocation(this.url).toString());
                        }
                        data[i] = trackData;
                    }
                    EtchedMusicDiscItem.setMusic(resultStack, data);
                    EtchedMusicDiscItem.setColor(resultStack, discColor, primaryLabelColor, secondaryLabelColor);
                    EtchedMusicDiscItem.setPattern(resultStack, EtchedMusicDiscItem.LabelPattern.values()[this.labelIndex.m_6501_()]);
                    return resultStack;
                }, (Executor)HttpUtil.f_13936_).thenAcceptAsync(resultStack -> {
                    if (this.urlId == currentId && !ItemStack.m_41728_((ItemStack)resultStack, (ItemStack)this.resultSlot.m_7993_()) && !ItemStack.m_41728_((ItemStack)resultStack, (ItemStack)this.discSlot.m_7993_())) {
                        this.resultSlot.m_5852_(resultStack);
                        ++this.urlId;
                        this.urlId %= 1000;
                        this.m_38946_();
                    }
                }, (Executor)level.m_7654_())).exceptionally(unused -> null);
            }
        }
    }

    public int getLabelIndex() {
        return this.labelIndex.m_6501_();
    }

    public void setUrl(String string) {
        if (!Objects.equals(this.url, string)) {
            this.url = string;
            ++this.urlId;
            this.urlId %= 1000;
            this.setupResultSlot();
        }
    }

    static {
        ImmutableSet.Builder builder = new ImmutableSet.Builder();
        builder.add((Object[])new String[]{"audio/wav", "audio/x-wav", "audio/opus", "application/ogg", "audio/ogg", "audio/mpeg", "audio/mp3", "application/octet-stream", "application/binary"});
        VALID_FORMATS = builder.build();
    }
}

