/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.etched.core.registry;

import com.google.common.collect.ImmutableSet;
import gg.moonflower.etched.core.mixin.StructureTemplatePoolAccessor;
import gg.moonflower.etched.core.registry.EtchedBlocks;
import gg.moonflower.etched.core.registry.EtchedItems;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.ProcessorLists;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber(modid="etched")
public class EtchedVillagers {
    public static final DeferredRegister<PoiType> POI_REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.POI_TYPES, (String)"etched");
    public static final DeferredRegister<VillagerProfession> PROFESSION_REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.VILLAGER_PROFESSIONS, (String)"etched");
    public static final RegistryObject<PoiType> BARD_POI = POI_REGISTRY.register("bard", () -> new PoiType((Set)ImmutableSet.builder().addAll((Iterable)Blocks.f_50065_.m_49965_().m_61056_()).build(), 1, 1));
    public static final RegistryObject<VillagerProfession> BARD = PROFESSION_REGISTRY.register("bard", () -> new VillagerProfession("etched:bard", poi -> poi.m_203373_(BARD_POI.getId()), poi -> poi.m_203373_(BARD_POI.getId()), ImmutableSet.of(), ImmutableSet.of(), null));

    @SubscribeEvent
    public static void onEvent(VillagerTradesEvent event) {
        if (event.getType() != BARD.get()) {
            return;
        }
        Int2ObjectOpenHashMap newTrades = new Int2ObjectOpenHashMap();
        int minTier = event.getTrades().keySet().intStream().min().orElse(1);
        int maxTier = event.getTrades().keySet().intStream().max().orElse(5);
        EtchedVillagers.registerTrades(arg_0 -> EtchedVillagers.lambda$onEvent$5(minTier, maxTier, (Int2ObjectMap)newTrades, arg_0));
        newTrades.forEach((tier, registry) -> ((List)event.getTrades().get(tier.intValue())).addAll(registry));
    }

    private static void registerTrades(Function<Integer, TradeRegistry> context) {
        TradeRegistry tier1 = context.apply(1);
        tier1.add((ItemLike)Items.f_42752_, 8, 1, 4, 20, true);
        tier1.add((ItemLike)Items.f_42710_, 8, 1, 4, 20, true);
        tier1.add((ItemLike)Items.f_42701_, 8, 1, 4, 20, true);
        tier1.add((ItemLike)Items.f_186363_, 8, 1, 4, 20, true);
        tier1.add((ItemLike)Items.f_41859_, 1, 2, 16, 2, true);
        tier1.add(EtchedItems.MUSIC_LABEL, 4, 2, 16, 1, false);
        TradeRegistry tier2 = context.apply(2);
        tier2.add(EtchedItems.BLANK_MUSIC_DISC, 28, 2, 12, 15, false);
        tier2.add((Supplier<? extends ItemLike>)EtchedBlocks.ETCHING_TABLE, 32, 1, 8, 15, false);
        TradeRegistry tier3 = context.apply(3);
        tier3.add((ItemLike)Blocks.f_50129_, 6, 1, 16, 2, false);
        tier3.add((ItemLike)Blocks.f_50335_, 12, 1, 8, 2, false);
        tier3.add((ItemLike)Blocks.f_50041_, 8, 1, 32, 4, false);
        tier3.add((ItemLike)Blocks.f_50453_, 24, 1, 8, 4, false);
        tier3.add((ItemLike)Blocks.f_50354_, 36, 1, 4, 8, false);
        tier3.add((ItemLike)Blocks.f_50074_, 48, 1, 2, 10, false);
        TradeRegistry tier4 = context.apply(4);
        tier3.add((ItemLike)Items.f_41984_, 26, 1, 4, 30, false);
        tier4.add(EtchedItems.JUKEBOX_MINECART, 28, 1, 4, 30, false);
        tier4.add((Supplier<? extends ItemLike>)EtchedBlocks.ALBUM_JUKEBOX, 30, 1, 4, 30, false);
        TradeRegistry tier5 = context.apply(5);
        tier5.add((ItemLike)Items.f_42415_, 8, 1, 8, 40, true);
        tier5.add((ItemLike)Items.f_151049_, 1, 8, 10, 40, true);
        BuiltInRegistries.f_257033_.m_203431_(ItemTags.f_13158_).ifPresent(tag -> tag.m_203614_().forEach(item -> tier5.add((ItemLike)item.m_203334_(), 10, 1, 4, 40, true)));
    }

    @SubscribeEvent
    public static void onEvent(ServerAboutToStartEvent event) {
        RegistryAccess.Frozen access = event.getServer().m_206579_();
        Optional templateRegistryOptional = access.m_6632_(Registries.f_256948_);
        Optional processorListRegistyOptional = access.m_6632_(Registries.f_257011_);
        if (templateRegistryOptional.isEmpty() || processorListRegistyOptional.isEmpty()) {
            return;
        }
        Registry templatePools = (Registry)templateRegistryOptional.get();
        Registry processorLists = (Registry)processorListRegistyOptional.get();
        EtchedVillagers.createVillagePiece((Registry<StructureTemplatePool>)templatePools, (Registry<StructureProcessorList>)processorLists, "plains", "bard_house", 1, 2, (ResourceKey<StructureProcessorList>)ProcessorLists.f_127204_, (ResourceKey<StructureProcessorList>)ProcessorLists.f_127199_);
        EtchedVillagers.createVillagePiece((Registry<StructureTemplatePool>)templatePools, (Registry<StructureProcessorList>)processorLists, "desert", "bard_house", 1, 2, (ResourceKey<StructureProcessorList>)ProcessorLists.f_127203_);
        EtchedVillagers.createVillagePiece((Registry<StructureTemplatePool>)templatePools, (Registry<StructureProcessorList>)processorLists, "savanna", "bard_house", 1, 4, (ResourceKey<StructureProcessorList>)ProcessorLists.f_127200_);
        EtchedVillagers.createVillagePiece((Registry<StructureTemplatePool>)templatePools, (Registry<StructureProcessorList>)processorLists, "snowy", "bard_house", 1, 4, (ResourceKey<StructureProcessorList>)ProcessorLists.f_127201_);
        EtchedVillagers.createVillagePiece((Registry<StructureTemplatePool>)templatePools, (Registry<StructureProcessorList>)processorLists, "taiga", "bard_house", 1, 4, (ResourceKey<StructureProcessorList>)ProcessorLists.f_127204_, (ResourceKey<StructureProcessorList>)ProcessorLists.f_127202_);
    }

    private static void createVillagePiece(Registry<StructureTemplatePool> templatePools, Registry<StructureProcessorList> processorLists, String village, String name, int houseId, int weight, ResourceKey<StructureProcessorList> zombieProcessor) {
        EtchedVillagers.createVillagePiece(templatePools, processorLists, village, name, houseId, weight, (ResourceKey<StructureProcessorList>)ProcessorLists.f_127198_, zombieProcessor);
    }

    private static void createVillagePiece(Registry<StructureTemplatePool> templatePools, Registry<StructureProcessorList> processorLists, String village, String name, int houseId, int weight, ResourceKey<StructureProcessorList> normalProcessor, ResourceKey<StructureProcessorList> zombieProcessor) {
        EtchedVillagers.addToPool((StructureTemplatePool)templatePools.m_7745_(new ResourceLocation("village/" + village + "/houses")), new ResourceLocation("etched", "village/" + village + "/houses/" + village + "_" + name + "_" + houseId), (Holder<StructureProcessorList>)((Holder)processorLists.m_203636_(normalProcessor).orElse(null)), weight);
        EtchedVillagers.addToPool((StructureTemplatePool)templatePools.m_7745_(new ResourceLocation("village/" + village + "/zombie/houses")), new ResourceLocation("etched", "village/" + village + "/houses/" + village + "_" + name + "_" + houseId), (Holder<StructureProcessorList>)((Holder)processorLists.m_203636_(zombieProcessor).orElse(null)), weight);
    }

    private static void addToPool(@Nullable StructureTemplatePool pool, ResourceLocation pieceId, @Nullable Holder<StructureProcessorList> processorList, int weight) {
        if (pool == null || processorList == null) {
            return;
        }
        StructurePoolElement piece = (StructurePoolElement)StructurePoolElement.m_210512_((String)pieceId.toString(), processorList).apply(StructureTemplatePool.Projection.RIGID);
        ObjectArrayList<StructurePoolElement> templates = ((StructureTemplatePoolAccessor)pool).getTemplates();
        if (templates == null) {
            return;
        }
        for (int i = 0; i < weight; ++i) {
            templates.add(piece);
        }
    }

    private static /* synthetic */ TradeRegistry lambda$onEvent$5(int minTier, int maxTier, Int2ObjectMap newTrades, Integer tier) {
        Validate.inclusiveBetween((long)minTier, (long)maxTier, (long)tier.intValue(), (String)("Tier must be between " + minTier + " and " + maxTier));
        return (TradeRegistry)newTrades.computeIfAbsent((Object)tier, key -> new TradeRegistry());
    }

    private static class TradeRegistry
    implements List<VillagerTrades.ItemListing> {
        private final List<VillagerTrades.ItemListing> trades = NonNullList.m_122779_();

        @Override
        public int size() {
            return this.trades.size();
        }

        @Override
        public boolean isEmpty() {
            return this.trades.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.trades.contains(o);
        }

        @Override
        @NotNull
        public Iterator<VillagerTrades.ItemListing> iterator() {
            return this.trades.iterator();
        }

        @Override
        @NotNull
        public Object[] toArray() {
            return this.trades.toArray();
        }

        @Override
        @NotNull
        public <T> T[] toArray(@NotNull T[] a) {
            return this.trades.toArray(a);
        }

        @Override
        public boolean add(VillagerTrades.ItemListing listing) {
            return this.trades.add(listing);
        }

        @Override
        public boolean remove(Object o) {
            return this.trades.remove(o);
        }

        @Override
        public boolean containsAll(@NotNull Collection<?> c) {
            return this.trades.containsAll(c);
        }

        @Override
        public boolean addAll(@NotNull Collection<? extends VillagerTrades.ItemListing> c) {
            return this.trades.addAll(c);
        }

        @Override
        public boolean addAll(int index, @NotNull Collection<? extends VillagerTrades.ItemListing> c) {
            return this.trades.addAll(index, c);
        }

        @Override
        public boolean removeAll(@NotNull Collection<?> c) {
            return this.trades.removeAll(c);
        }

        @Override
        public boolean retainAll(@NotNull Collection<?> c) {
            return this.trades.retainAll(c);
        }

        @Override
        public void clear() {
            this.trades.clear();
        }

        @Override
        public VillagerTrades.ItemListing get(int index) {
            return this.trades.get(index);
        }

        @Override
        public VillagerTrades.ItemListing set(int index, VillagerTrades.ItemListing element) {
            return this.trades.set(index, element);
        }

        @Override
        public void add(int index, VillagerTrades.ItemListing element) {
            this.trades.add(index, element);
        }

        @Override
        public VillagerTrades.ItemListing remove(int index) {
            return this.trades.remove(index);
        }

        @Override
        public int indexOf(Object o) {
            return this.trades.indexOf(o);
        }

        @Override
        public int lastIndexOf(Object o) {
            return this.trades.lastIndexOf(o);
        }

        @Override
        @NotNull
        public ListIterator<VillagerTrades.ItemListing> listIterator() {
            return this.trades.listIterator();
        }

        @Override
        @NotNull
        public ListIterator<VillagerTrades.ItemListing> listIterator(int index) {
            return this.trades.listIterator(index);
        }

        @Override
        @NotNull
        public List<VillagerTrades.ItemListing> subList(int fromIndex, int toIndex) {
            return this.trades.subList(fromIndex, toIndex);
        }

        public void add(ItemLike item, int emeralds, int itemCount, int maxUses, int xpGain, boolean sellToVillager) {
            this.add(new ItemTrade(() -> item, emeralds, itemCount, maxUses, xpGain, 0.05f, sellToVillager));
        }

        public void add(ItemLike item, int emeralds, int itemCount, int maxUses, int xpGain, float priceMultiplier, boolean sellToVillager) {
            this.add(new ItemTrade(() -> item, emeralds, itemCount, maxUses, xpGain, priceMultiplier, sellToVillager));
        }

        public void add(Supplier<? extends ItemLike> item, int emeralds, int itemCount, int maxUses, int xpGain, boolean sellToVillager) {
            this.add(new ItemTrade(item, emeralds, itemCount, maxUses, xpGain, 0.05f, sellToVillager));
        }

        public void add(Supplier<? extends ItemLike> item, int emeralds, int itemCount, int maxUses, int xpGain, float priceMultiplier, boolean sellToVillager) {
            this.add(new ItemTrade(item, emeralds, itemCount, maxUses, xpGain, priceMultiplier, sellToVillager));
        }
    }

    private static class ItemTrade
    implements VillagerTrades.ItemListing {
        private final Supplier<? extends ItemLike> item;
        private final int emeralds;
        private final int itemCount;
        private final int maxUses;
        private final int xpGain;
        private final float priceMultiplier;
        private final boolean sellToVillager;

        private ItemTrade(Supplier<? extends ItemLike> Item2, int emeralds, int itemCount, int maxUses, int xpGain, float priceMultiplier, boolean sellToVillager) {
            this.item = Item2;
            this.emeralds = emeralds;
            this.itemCount = itemCount;
            this.maxUses = maxUses;
            this.xpGain = xpGain;
            this.priceMultiplier = priceMultiplier;
            this.sellToVillager = sellToVillager;
        }

        public MerchantOffer m_213663_(Entity entity, RandomSource random) {
            ItemStack emeralds = new ItemStack((ItemLike)Items.f_42616_, this.emeralds);
            ItemStack item = new ItemStack(this.item.get(), this.itemCount);
            return new MerchantOffer(this.sellToVillager ? item : emeralds, this.sellToVillager ? emeralds : item, this.maxUses, this.xpGain, this.priceMultiplier);
        }
    }
}

