/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.gui.screen;

import com.google.common.base.Preconditions;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.datafixers.util.Either;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.ExposureClient;
import io.github.mortuusars.exposure.camera.infrastructure.FilmType;
import io.github.mortuusars.exposure.data.storage.ExposureSavedData;
import io.github.mortuusars.exposure.gui.screen.PhotographScreen;
import io.github.mortuusars.exposure.gui.screen.ZoomableScreen;
import io.github.mortuusars.exposure.gui.screen.element.Pager;
import io.github.mortuusars.exposure.render.image.ExposureDataImage;
import io.github.mortuusars.exposure.render.image.IImage;
import io.github.mortuusars.exposure.render.image.RenderedImageProvider;
import io.github.mortuusars.exposure.render.image.TextureImage;
import io.github.mortuusars.exposure.render.modifiers.ExposurePixelModifiers;
import io.github.mortuusars.exposure.util.GuiUtil;
import io.github.mortuusars.exposure.util.PagingDirection;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NegativeExposureScreen
extends ZoomableScreen {
    public static final ResourceLocation TEXTURE = Exposure.resource("textures/gui/film_frame_inspect.png");
    public static final int BG_SIZE = 78;
    public static final int FRAME_SIZE = 54;
    private final Pager pager = new Pager(Exposure.SoundEvents.CAMERA_LENS_RING_CLICK.get());
    private final List<Either<String, ResourceLocation>> exposures;

    public NegativeExposureScreen(List<Either<String, ResourceLocation>> exposures) {
        super((Component)Component.m_237119_());
        this.exposures = exposures;
        Preconditions.checkArgument((exposures != null && !exposures.isEmpty() ? 1 : 0) != 0);
        this.zoom.step = 2.0f;
        this.zoom.defaultZoom = 1.0f;
        this.zoom.targetZoom = 1.0f;
        this.zoom.minZoom = this.zoom.defaultZoom / (float)Math.pow(this.zoom.step, 1.0);
        this.zoom.maxZoom = this.zoom.defaultZoom * (float)Math.pow(this.zoom.step, 5.0);
    }

    public boolean m_7043_() {
        return false;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.zoomFactor = 1.0f / (float)((Integer)this.minecraft.f_91066_.m_231928_().m_231551_() + 1);
        ImageButton previousButton = new ImageButton(0, (int)((float)this.f_96544_ / 2.0f - 8.0f), 16, 16, 0, 0, 16, PhotographScreen.WIDGETS_TEXTURE, 256, 256, button -> this.pager.changePage(PagingDirection.PREVIOUS), (Component)Component.m_237115_((String)"gui.exposure.previous_page"));
        this.m_142416_((GuiEventListener)previousButton);
        ImageButton nextButton = new ImageButton(this.f_96543_ - 16, (int)((float)this.f_96544_ / 2.0f - 8.0f), 16, 16, 16, 0, 16, PhotographScreen.WIDGETS_TEXTURE, 256, 256, button -> this.pager.changePage(PagingDirection.NEXT), (Component)Component.m_237115_((String)"gui.exposure.next_page"));
        this.m_142416_((GuiEventListener)nextButton);
        this.pager.init(this.exposures.size(), true, (AbstractButton)previousButton, (AbstractButton)nextButton);
    }

    @Override
    public void m_88315_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        IImage image;
        this.pager.update();
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        Either<String, ResourceLocation> idOrTexture = this.exposures.get(this.pager.getCurrentPage());
        @Nullable FilmType type = (FilmType)((Object)idOrTexture.map(id -> ExposureClient.getExposureStorage().getOrQuery((String)id).map(ExposureSavedData::getType).orElse(FilmType.BLACK_AND_WHITE), texture -> texture.m_135815_().endsWith("_black_and_white") || texture.m_135815_().endsWith("_bw") ? FilmType.COLOR : FilmType.BLACK_AND_WHITE));
        if (type == null) {
            type = FilmType.BLACK_AND_WHITE;
        }
        if ((image = (IImage)idOrTexture.map(id -> ExposureClient.getExposureStorage().getOrQuery((String)id).map(data -> new ExposureDataImage((String)id, (ExposureSavedData)((Object)((Object)data)))).orElse(null), TextureImage::getTexture)) == null) {
            return;
        }
        int width = image.getWidth();
        int height = image.getHeight();
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_(this.x + (float)this.f_96543_ / 2.0f, this.y + (float)this.f_96544_ / 2.0f, 0.0f);
        guiGraphics.m_280168_().m_85841_(this.scale, this.scale, this.scale);
        guiGraphics.m_280168_().m_252880_((float)(-width) / 2.0f, (float)(-height) / 2.0f, 0.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        guiGraphics.m_280168_().m_85836_();
        float scale = Math.max((float)width / 54.0f, (float)height / 54.0f);
        guiGraphics.m_280168_().m_85841_(scale, scale, scale);
        guiGraphics.m_280168_().m_252880_(-12.0f, -12.0f, 0.0f);
        GuiUtil.blit(guiGraphics.m_280168_(), 0.0f, 0.0f, 78.0f, 78.0f, 0, 0, 256, 256, 0.0f);
        RenderSystem.setShaderColor((float)type.filmR, (float)type.filmG, (float)type.filmB, (float)type.filmA);
        GuiUtil.blit(guiGraphics.m_280168_(), 0.0f, 0.0f, 78.0f, 78.0f, 0, 78, 256, 256, 0.0f);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.m_280168_().m_85849_();
        MultiBufferSource.BufferSource bufferSource = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        ExposureClient.getExposureRenderer().render(new RenderedImageProvider(image), ExposurePixelModifiers.NEGATIVE_FILM, guiGraphics.m_280168_(), (MultiBufferSource)bufferSource, 0.0f, 0.0f, width, height, 0.0f, 0.0f, 1.0f, 1.0f, 0xF000F0, type.frameR, type.frameG, type.frameB, 255);
        bufferSource.m_109911_();
        guiGraphics.m_280168_().m_85849_();
    }

    @Override
    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        return this.pager.handleKeyPressed(keyCode, scanCode, modifiers) || super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_7920_(int keyCode, int scanCode, int modifiers) {
        return this.pager.handleKeyReleased(keyCode, scanCode, modifiers) || super.m_7920_(keyCode, scanCode, modifiers);
    }
}

