/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.menu;

import com.google.common.base.Preconditions;
import io.github.mortuusars.exposure.Exposure;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemRenameMenu
extends AbstractContainerMenu {
    public static final int MAX_NAME_LENGTH = 50;
    public static final int APPLY_BUTTON_ID = 0;
    protected final Inventory playerInventory;
    protected final int slot;
    protected final Item item;
    protected String itemName;

    public ItemRenameMenu(int containerId, Inventory playerInventory, int slot) {
        super(Exposure.MenuTypes.ITEM_RENAME.get(), containerId);
        this.playerInventory = playerInventory;
        this.slot = slot;
        ItemStack itemStack = playerInventory.m_8020_(slot);
        Preconditions.checkArgument((!itemStack.m_41619_() ? 1 : 0) != 0, (Object)("Cannot rename empty item in slot " + slot));
        this.item = itemStack.m_41720_();
        this.itemName = itemStack.m_41786_().getString();
        SimpleContainer container = new SimpleContainer(new ItemStack[]{itemStack});
        this.m_38897_(new Slot((Container)container, 0, 4, 16){

            public boolean m_5857_(ItemStack stack) {
                return false;
            }

            public boolean m_8010_(Player player) {
                return false;
            }

            public boolean m_280329_() {
                return false;
            }
        });
    }

    public static ItemRenameMenu fromBuffer(int containerId, Inventory playerInventory, FriendlyByteBuf buffer) {
        return new ItemRenameMenu(containerId, playerInventory, buffer.readInt());
    }

    public Player getPlayer() {
        return this.playerInventory.f_35978_;
    }

    @NotNull
    public ItemStack m_7648_(Player player, int index) {
        return ItemStack.f_41583_;
    }

    public boolean m_6875_(Player player) {
        return this.item.getClass().isAssignableFrom(player.m_150109_().m_8020_(this.slot).m_41720_().getClass());
    }

    public void updateResult() {
        ItemStack itemStack = this.m_38853_(0).m_7993_();
        ItemStack itemStack2 = itemStack.m_41777_();
        if (Util.m_288217_((String)this.itemName)) {
            if (itemStack.m_41788_()) {
                itemStack2.m_41787_();
            }
        } else if (!this.itemName.equals(itemStack.m_41786_().getString())) {
            itemStack2.m_41714_((Component)Component.m_237113_((String)this.itemName));
        }
        this.m_38853_(0).m_5852_(itemStack2);
        this.m_38946_();
    }

    public String getItemName() {
        return this.itemName;
    }

    public boolean setItemName(String itemName) {
        String string = this.validateName(itemName);
        if (string == null || !string.equals(itemName)) {
            return false;
        }
        this.itemName = string;
        this.updateResult();
        return true;
    }

    @Nullable
    public String validateName(String itemName) {
        String string = SharedConstants.m_136190_((String)itemName);
        if (string.length() <= 50) {
            return string;
        }
        return null;
    }

    public boolean m_6366_(Player player, int id) {
        if (id == 0) {
            this.playerInventory.m_6836_(this.slot, this.m_38853_(0).m_7993_());
        }
        return super.m_6366_(player, id);
    }
}

