/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model.cube;

import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.ChunkRenderTypeSet;
import net.minecraftforge.client.model.data.ModelData;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.model.FramedBlockModel;
import xfacthd.framedblocks.api.model.quad.Modifiers;
import xfacthd.framedblocks.api.model.quad.QuadModifier;
import xfacthd.framedblocks.api.model.util.ModelUtils;
import xfacthd.framedblocks.api.util.ClientUtils;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.ChestState;
import xfacthd.framedblocks.common.data.property.LatchType;

public class FramedChestModel
extends FramedBlockModel {
    private final Direction facing;
    private final boolean closed;
    private final LatchType latch;
    private final ChunkRenderTypeSet addLayers;

    public FramedChestModel(BlockState state, BakedModel baseModel) {
        super(state, baseModel);
        this.facing = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
        this.closed = state.m_61143_(PropertyHolder.CHEST_STATE) == ChestState.CLOSED || ClientUtils.OPTIFINE_LOADED.get() != false;
        this.latch = (LatchType)((Object)state.m_61143_(PropertyHolder.LATCH_TYPE));
        this.addLayers = this.latch == LatchType.DEFAULT ? ModelUtils.CUTOUT : ChunkRenderTypeSet.none();
    }

    @Override
    protected void transformQuad(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad) {
        Direction quadDir = quad.m_111306_();
        if (Utils.isY(quad.m_111306_())) {
            QuadModifier.geometry(quad).apply(Modifiers.cutTopBottom(0.0625f, 0.0625f, 0.9375f, 0.9375f)).applyIf(Modifiers.setPosition(this.closed ? 0.875f : 0.625f), quadDir == Direction.UP).export(quadMap.get(quadDir == Direction.UP ? null : quadDir));
        } else {
            QuadModifier.geometry(quad).apply(Modifiers.cutSide(0.0625f, 0.0f, 0.9375f, this.closed ? 0.875f : 0.625f)).apply(Modifiers.setPosition(0.9375f)).export(quadMap.get(null));
        }
        if (this.latch == LatchType.CAMO && this.closed) {
            FramedChestModel.makeChestLatch(quadMap, quad, this.facing);
        }
    }

    public static void makeChestLatch(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad, Direction facing) {
        Direction face = quad.m_111306_();
        if (face == facing || face == facing.m_122424_()) {
            QuadModifier.geometry(quad).apply(Modifiers.cutSide(0.4375f, 0.4375f, 0.5625f, 0.6875f)).applyIf(Modifiers.setPosition(0.0625f), face != facing).export(quadMap.get(face == facing ? facing : null));
        } else if (Utils.isY(face)) {
            QuadModifier.geometry(quad).apply(Modifiers.cutTopBottom(facing.m_122424_(), 0.0625f)).apply(Modifiers.cutTopBottom(facing.m_122427_(), 0.5625f)).apply(Modifiers.cutTopBottom(facing.m_122428_(), 0.5625f)).apply(Modifiers.setPosition(face == Direction.UP ? 0.6875f : 0.5625f)).export(quadMap.get(null));
        } else {
            QuadModifier.geometry(quad).apply(Modifiers.cutSide(0.0f, 0.4375f, 1.0f, 0.6875f)).apply(Modifiers.cutSideLeftRight(facing.m_122424_(), 0.0625f)).apply(Modifiers.setPosition(0.5625f)).export(quadMap.get(null));
        }
    }

    @Override
    protected ChunkRenderTypeSet getAdditionalRenderTypes(RandomSource rand, ModelData extraData) {
        return this.addLayers;
    }

    @Override
    protected void getAdditionalQuads(Map<Direction, List<BakedQuad>> quadMap, BlockState state, RandomSource rand, ModelData data, RenderType renderType) {
        if (!this.closed || this.latch != LatchType.DEFAULT) {
            return;
        }
        List quads = this.baseModel.getQuads(state, null, rand, data, renderType);
        for (BakedQuad quad : quads) {
            quadMap.get(null).add(quad);
        }
    }

    public static BlockState itemSource() {
        return ((Block)FBContent.BLOCK_FRAMED_CHEST.get()).m_49966_();
    }
}

