/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block;

import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.PlacementStateBuilder;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.CornerType;
import xfacthd.framedblocks.common.data.property.HorizontalRotation;
import xfacthd.framedblocks.common.data.property.SlopeType;

public final class ExtPlacementStateBuilder
extends PlacementStateBuilder<ExtPlacementStateBuilder> {
    private ExtPlacementStateBuilder(Block block, BlockPlaceContext ctx) {
        super(block, ctx);
    }

    public static ExtPlacementStateBuilder of(Block block, BlockPlaceContext ctx) {
        return new ExtPlacementStateBuilder(block, ctx);
    }

    public ExtPlacementStateBuilder withRight() {
        if (this.state == null) {
            return (ExtPlacementStateBuilder)this.self();
        }
        boolean right = Utils.fractionInDir(this.ctx.m_43720_(), this.ctx.m_8125_().m_122427_()) > 0.5;
        this.state = (BlockState)this.state.m_61124_((Property)PropertyHolder.RIGHT, (Comparable)Boolean.valueOf(right));
        return (ExtPlacementStateBuilder)this.self();
    }

    public ExtPlacementStateBuilder withHorizontalFacingAndSlopeType() {
        if (this.state == null) {
            return (ExtPlacementStateBuilder)this.self();
        }
        Direction side = this.ctx.m_43719_();
        Direction facing = this.ctx.m_8125_();
        this.state = (BlockState)this.state.m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)facing);
        if (!Utils.isY(side)) {
            double y = Utils.fractionInDir(this.ctx.m_43720_(), Direction.UP);
            if (y < 0.1875) {
                side = Direction.UP;
            } else if (y > 0.8125) {
                side = Direction.DOWN;
            }
        }
        if (side == Direction.DOWN) {
            this.state = (BlockState)this.state.m_61124_(PropertyHolder.SLOPE_TYPE, (Comparable)((Object)SlopeType.TOP));
        } else if (side == Direction.UP) {
            this.state = (BlockState)this.state.m_61124_(PropertyHolder.SLOPE_TYPE, (Comparable)((Object)SlopeType.BOTTOM));
        } else {
            this.state = (BlockState)this.state.m_61124_(PropertyHolder.SLOPE_TYPE, (Comparable)((Object)SlopeType.HORIZONTAL));
            this.withHalfOrHorizontalFacing();
        }
        return (ExtPlacementStateBuilder)this.self();
    }

    public ExtPlacementStateBuilder withHorizontalFacingAndCornerType() {
        if (this.state == null) {
            return (ExtPlacementStateBuilder)this.self();
        }
        Direction side = this.ctx.m_43719_();
        Vec3 hitPoint = Utils.fraction(this.ctx.m_43720_());
        Direction typeSide = side;
        if (!Utils.isY(side)) {
            if (hitPoint.m_7098_() < 0.1875) {
                typeSide = Direction.UP;
            } else if (hitPoint.m_7098_() > 0.8125) {
                typeSide = Direction.DOWN;
            }
        }
        if (typeSide == Direction.DOWN) {
            this.state = (BlockState)this.state.m_61124_(PropertyHolder.CORNER_TYPE, (Comparable)((Object)CornerType.TOP));
            this.withHalfFacing();
        } else if (typeSide == Direction.UP) {
            this.state = (BlockState)this.state.m_61124_(PropertyHolder.CORNER_TYPE, (Comparable)((Object)CornerType.BOTTOM));
            this.withHalfFacing();
        } else {
            boolean xAxis = Utils.isX(side);
            boolean positive = Utils.isPositive(side.m_122428_());
            double xz = xAxis ? hitPoint.m_7094_() : hitPoint.m_7096_();
            double y = hitPoint.m_7098_();
            CornerType type = xz > 0.5 == positive ? (y > 0.5 ? CornerType.HORIZONTAL_TOP_RIGHT : CornerType.HORIZONTAL_BOTTOM_RIGHT) : (y > 0.5 ? CornerType.HORIZONTAL_TOP_LEFT : CornerType.HORIZONTAL_BOTTOM_LEFT);
            this.state = (BlockState)((BlockState)this.state.m_61124_(PropertyHolder.CORNER_TYPE, (Comparable)((Object)type))).m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)this.ctx.m_8125_());
        }
        return (ExtPlacementStateBuilder)this.self();
    }

    public ExtPlacementStateBuilder withCornerOrSideRotation() {
        return this.withCornerOrSideRotation(false);
    }

    public ExtPlacementStateBuilder withCornerOrSideRotation(boolean opposite) {
        if (this.state == null) {
            return (ExtPlacementStateBuilder)this.self();
        }
        Direction facing = this.ctx.m_8125_();
        Direction side = this.ctx.m_43719_();
        if (side == facing) {
            this.state = null;
            return (ExtPlacementStateBuilder)this.self();
        }
        HorizontalRotation rotation = side == facing.m_122424_() ? HorizontalRotation.fromWallCorner(this.ctx.m_43720_(), side) : HorizontalRotation.fromDirection(facing, side, this.ctx.m_43720_());
        if (opposite) {
            rotation = rotation.getOpposite();
        }
        this.state = (BlockState)this.state.m_61124_(PropertyHolder.ROTATION, (Comparable)((Object)rotation));
        return (ExtPlacementStateBuilder)this.self();
    }

    public ExtPlacementStateBuilder withCrossOrSideRotation() {
        return this.withCrossOrSideRotation(false);
    }

    public ExtPlacementStateBuilder withCrossOrSideRotation(boolean opposite) {
        if (this.state == null) {
            return (ExtPlacementStateBuilder)this.self();
        }
        Direction facing = this.ctx.m_8125_();
        Direction side = this.ctx.m_43719_();
        if (side == facing) {
            this.state = null;
            return (ExtPlacementStateBuilder)this.self();
        }
        HorizontalRotation rotation = side == facing.m_122424_() ? HorizontalRotation.fromWallCross(this.ctx.m_43720_(), side) : HorizontalRotation.fromDirection(facing, side);
        if (opposite) {
            rotation = rotation.getOpposite();
        }
        this.state = (BlockState)this.state.m_61124_(PropertyHolder.ROTATION, (Comparable)((Object)rotation));
        return (ExtPlacementStateBuilder)this.self();
    }

    public ExtPlacementStateBuilder withCornerRotation() {
        return this.withCornerRotation(false);
    }

    public ExtPlacementStateBuilder withCornerRotation(boolean opposite) {
        if (this.state == null) {
            return (ExtPlacementStateBuilder)this.self();
        }
        HorizontalRotation rotation = HorizontalRotation.fromWallCorner(this.ctx.m_43720_(), this.ctx.m_43719_());
        if (opposite) {
            rotation = rotation.getOpposite();
        }
        this.state = (BlockState)this.state.m_61124_(PropertyHolder.ROTATION, (Comparable)((Object)rotation));
        return (ExtPlacementStateBuilder)this.self();
    }

    public ExtPlacementStateBuilder withCrossRotation() {
        return this.withCrossRotation(false);
    }

    public ExtPlacementStateBuilder withCrossRotation(boolean opposite) {
        if (this.state == null) {
            return (ExtPlacementStateBuilder)this.self();
        }
        HorizontalRotation rotation = HorizontalRotation.fromWallCross(this.ctx.m_43720_(), this.ctx.m_43719_());
        if (opposite) {
            rotation = rotation.getOpposite();
        }
        this.state = (BlockState)this.state.m_61124_(PropertyHolder.ROTATION, (Comparable)((Object)rotation));
        return (ExtPlacementStateBuilder)this.self();
    }

    public ExtPlacementStateBuilder withFront() {
        if (this.state == null) {
            return (ExtPlacementStateBuilder)this.self();
        }
        Direction facing = this.ctx.m_8125_();
        if (facing.m_122434_() != this.ctx.m_43719_().m_122434_()) {
            double xz = Utils.fractionInDir(this.ctx.m_43720_(), facing);
            this.state = (BlockState)this.state.m_61124_((Property)PropertyHolder.FRONT, (Comparable)Boolean.valueOf(xz < 0.5));
        }
        return (ExtPlacementStateBuilder)this.self();
    }
}

