/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.pillar;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.PlacementStateBuilder;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.block.AbstractFramedDoubleBlock;
import xfacthd.framedblocks.common.blockentity.doubled.FramedDoubleThreewayCornerPillarBlockEntity;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.doubleblock.CamoGetter;
import xfacthd.framedblocks.common.data.doubleblock.SolidityCheck;
import xfacthd.framedblocks.common.util.DoubleBlockTopInteractionMode;

public class FramedDoubleThreewayCornerPillarBlock
extends AbstractFramedDoubleBlock {
    public FramedDoubleThreewayCornerPillarBlock() {
        super(BlockType.FRAMED_DOUBLE_THREEWAY_CORNER_PILLAR);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)FramedProperties.TOP, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FramedProperties.FACING_HOR, FramedProperties.TOP});
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        return ((PlacementStateBuilder)((PlacementStateBuilder)PlacementStateBuilder.of(this, ctx).withHalfFacing()).withTop()).build();
    }

    @Override
    public BlockState rotate(BlockState state, Direction face, Rotation rot) {
        if (Utils.isY(face)) {
            Direction dir = rot.m_55954_((Direction)state.m_61143_((Property)FramedProperties.FACING_HOR));
            return (BlockState)state.m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)dir);
        }
        if (rot != Rotation.NONE) {
            return (BlockState)state.m_61122_((Property)FramedProperties.TOP);
        }
        return state;
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return this.rotate(state, Direction.UP, rot);
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return Utils.mirrorCornerBlock(state, mirror);
    }

    @Override
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new FramedDoubleThreewayCornerPillarBlockEntity(pos, state);
    }

    @Override
    public DoubleBlockTopInteractionMode calculateTopInteractionMode(BlockState state) {
        return DoubleBlockTopInteractionMode.EITHER;
    }

    @Override
    public Tuple<BlockState, BlockState> calculateBlockPair(BlockState state) {
        BlockState partState = ((Block)FBContent.BLOCK_FRAMED_THREEWAY_CORNER_PILLAR.get()).m_49966_();
        Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean top = (Boolean)state.m_61143_((Property)FramedProperties.TOP);
        return new Tuple((Object)((BlockState)((BlockState)partState.m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)dir)).m_61124_((Property)FramedProperties.TOP, (Comparable)Boolean.valueOf(top))), (Object)((BlockState)((BlockState)partState.m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)dir.m_122424_())).m_61124_((Property)FramedProperties.TOP, (Comparable)Boolean.valueOf(!top))));
    }

    @Override
    public SolidityCheck calculateSolidityCheck(BlockState state, Direction side) {
        return SolidityCheck.BOTH;
    }

    @Override
    public CamoGetter calculateCamoGetter(BlockState state, Direction side, @Nullable Direction edge) {
        Direction dirTwo;
        if (edge == null) {
            return CamoGetter.NONE;
        }
        Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean top = (Boolean)state.m_61143_((Property)FramedProperties.TOP);
        Direction direction = dirTwo = top ? Direction.UP : Direction.DOWN;
        if (side == dirTwo && (edge == dir || edge == dir.m_122428_())) {
            return CamoGetter.FIRST;
        }
        if (side == dirTwo.m_122424_() && (edge == dir.m_122424_() || edge == dir.m_122427_())) {
            return CamoGetter.SECOND;
        }
        if (side == dir && (edge == dir.m_122428_() || edge == dirTwo)) {
            return CamoGetter.FIRST;
        }
        if (side == dir.m_122428_() && (edge == dir || edge == dirTwo)) {
            return CamoGetter.FIRST;
        }
        if (side == dir.m_122424_() && (edge == dir.m_122427_() || edge == dirTwo.m_122424_())) {
            return CamoGetter.SECOND;
        }
        if (side == dir.m_122427_() && (edge == dir.m_122424_() || edge == dirTwo.m_122424_())) {
            return CamoGetter.SECOND;
        }
        return CamoGetter.NONE;
    }

    public static BlockState itemModelSource() {
        return (BlockState)((Block)FBContent.BLOCK_FRAMED_DOUBLE_THREEWAY_CORNER_PILLAR.get()).m_49966_().m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)Direction.WEST);
    }
}

