/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.slopeslab;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.block.PlacementStateBuilder;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.block.AbstractFramedDoubleBlock;
import xfacthd.framedblocks.common.blockentity.doubled.FramedStackedSlopeSlabBlockEntity;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.doubleblock.CamoGetter;
import xfacthd.framedblocks.common.data.doubleblock.SolidityCheck;
import xfacthd.framedblocks.common.util.DoubleBlockTopInteractionMode;

public class FramedFlatStackedSlopeSlabCornerBlock
extends AbstractFramedDoubleBlock {
    private final boolean corner;

    public FramedFlatStackedSlopeSlabCornerBlock(BlockType type) {
        super(type);
        this.corner = type == BlockType.FRAMED_FLAT_STACKED_SLOPE_SLAB_CORNER;
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FramedProperties.TOP, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FramedProperties.Y_SLOPE, (Comparable)Boolean.valueOf(true)));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FramedProperties.FACING_HOR, FramedProperties.TOP, FramedProperties.Y_SLOPE, BlockStateProperties.f_61362_});
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        return ((PlacementStateBuilder)((PlacementStateBuilder)((PlacementStateBuilder)PlacementStateBuilder.of(this, ctx).withHalfFacing()).withTop()).withWater()).build();
    }

    @Override
    public boolean handleBlockLeftClick(BlockState state, Level level, BlockPos pos, Player player) {
        return IFramedBlock.toggleYSlope(state, level, pos, player);
    }

    @Override
    public BlockState rotate(BlockState state, BlockHitResult hit, Rotation rot) {
        Direction dir;
        Direction face = hit.m_82434_();
        if (face == (dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR)).m_122424_() || face == dir.m_122427_()) {
            boolean top = (Boolean)state.m_61143_((Property)FramedProperties.TOP);
            Vec3 vec = Utils.fraction(hit.m_82450_());
            if (this.getBlockType() == BlockType.FRAMED_FLAT_STACKED_SLOPE_SLAB_CORNER) {
                if (vec.f_82480_ > 0.5 != top) {
                    face = Direction.UP;
                }
            } else {
                double hor;
                Direction perpDir = face == dir.m_122427_() ? dir : dir.m_122428_();
                double d = hor = Utils.isX(perpDir) ? vec.m_7096_() : vec.m_7094_();
                if (!Utils.isPositive(perpDir)) {
                    hor = 1.0 - hor;
                }
                double y = vec.m_7098_();
                if (top) {
                    y = 1.0 - y;
                }
                if ((y -= 0.5) * 2.0 >= hor) {
                    face = Direction.UP;
                }
            }
        }
        return this.rotate(state, face, rot);
    }

    @Override
    public BlockState rotate(BlockState state, Direction face, Rotation rot) {
        if (Utils.isY(face)) {
            Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
            return (BlockState)state.m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)rot.m_55954_(dir));
        }
        if (rot != Rotation.NONE) {
            return (BlockState)state.m_61122_((Property)FramedProperties.TOP);
        }
        return state;
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return this.rotate(state, Direction.UP, rot);
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return Utils.mirrorCornerBlock(state, mirror);
    }

    @Override
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new FramedStackedSlopeSlabBlockEntity(pos, state);
    }

    @Override
    public Tuple<BlockState, BlockState> calculateBlockPair(BlockState state) {
        Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean top = (Boolean)state.m_61143_((Property)FramedProperties.TOP);
        boolean ySlope = (Boolean)state.m_61143_((Property)FramedProperties.Y_SLOPE);
        Block topBlock = this.getBlockType() == BlockType.FRAMED_FLAT_STACKED_INNER_SLOPE_SLAB_CORNER ? (Block)FBContent.BLOCK_FRAMED_FLAT_INNER_SLOPE_SLAB_CORNER.get() : (Block)FBContent.BLOCK_FRAMED_FLAT_SLOPE_SLAB_CORNER.get();
        return new Tuple((Object)((BlockState)((Block)FBContent.BLOCK_FRAMED_SLAB.get()).m_49966_().m_61124_((Property)FramedProperties.TOP, (Comparable)Boolean.valueOf(top))), (Object)((BlockState)((BlockState)((BlockState)((BlockState)topBlock.m_49966_().m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)dir)).m_61124_((Property)FramedProperties.TOP, (Comparable)Boolean.valueOf(top))).m_61124_((Property)PropertyHolder.TOP_HALF, (Comparable)Boolean.valueOf(!top))).m_61124_((Property)FramedProperties.Y_SLOPE, (Comparable)Boolean.valueOf(ySlope))));
    }

    @Override
    public DoubleBlockTopInteractionMode calculateTopInteractionMode(BlockState state) {
        if (((Boolean)state.m_61143_((Property)FramedProperties.TOP)).booleanValue()) {
            return DoubleBlockTopInteractionMode.FIRST;
        }
        return DoubleBlockTopInteractionMode.SECOND;
    }

    @Override
    public CamoGetter calculateCamoGetter(BlockState state, Direction side, @Nullable Direction edge) {
        Direction facing;
        Direction dirTwo;
        boolean top = (Boolean)state.m_61143_((Property)FramedProperties.TOP);
        Direction direction = dirTwo = top ? Direction.UP : Direction.DOWN;
        if (side == dirTwo || !Utils.isY(side) && edge == dirTwo) {
            return CamoGetter.FIRST;
        }
        if (!(this.corner || edge != dirTwo.m_122424_() || side != (facing = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR)) && side != facing.m_122428_())) {
            return CamoGetter.SECOND;
        }
        return CamoGetter.NONE;
    }

    @Override
    public SolidityCheck calculateSolidityCheck(BlockState state, Direction side) {
        Direction facing;
        boolean top = (Boolean)state.m_61143_((Property)FramedProperties.TOP);
        if (!top && side == Direction.DOWN || top && side == Direction.UP) {
            return SolidityCheck.FIRST;
        }
        if (!(this.corner || side != (facing = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR)) && side != facing.m_122428_())) {
            return SolidityCheck.BOTH;
        }
        return SolidityCheck.NONE;
    }

    public static BlockState itemModelSource() {
        return (BlockState)((Block)FBContent.BLOCK_FRAMED_FLAT_STACKED_SLOPE_SLAB_CORNER.get()).m_49966_().m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)Direction.SOUTH);
    }

    public static BlockState itemModelSourceInner() {
        return (BlockState)((Block)FBContent.BLOCK_FRAMED_FLAT_STACKED_INNER_SLOPE_SLAB_CORNER.get()).m_49966_().m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)Direction.SOUTH);
    }
}

