/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.stairs;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.PlacementStateBuilder;
import xfacthd.framedblocks.api.shapes.CommonShapes;
import xfacthd.framedblocks.api.shapes.ShapeProvider;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.block.AbstractFramedDoubleBlock;
import xfacthd.framedblocks.common.blockentity.doubled.FramedVerticalDoubleHalfStairsBlockEntity;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.doubleblock.CamoGetter;
import xfacthd.framedblocks.common.data.doubleblock.SolidityCheck;
import xfacthd.framedblocks.common.util.DoubleBlockTopInteractionMode;

public class FramedVerticalDoubleHalfStairsBlock
extends AbstractFramedDoubleBlock {
    public FramedVerticalDoubleHalfStairsBlock() {
        super(BlockType.FRAMED_VERTICAL_DOUBLE_HALF_STAIRS);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)FramedProperties.TOP, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FramedProperties.FACING_HOR, FramedProperties.TOP, BlockStateProperties.f_61362_});
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        return ((PlacementStateBuilder)((PlacementStateBuilder)((PlacementStateBuilder)PlacementStateBuilder.of(this, ctx).withHalfFacing()).withTop()).withWater()).build();
    }

    @Override
    public BlockState rotate(BlockState state, Direction face, Rotation rot) {
        if (Utils.isY(face)) {
            Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
            return (BlockState)state.m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)rot.m_55954_(dir));
        }
        if (rot != Rotation.NONE) {
            return (BlockState)state.m_61122_((Property)FramedProperties.TOP);
        }
        return state;
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return this.rotate(state, Direction.UP, rot);
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return Utils.mirrorCornerBlock(state, mirror);
    }

    @Override
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new FramedVerticalDoubleHalfStairsBlockEntity(pos, state);
    }

    @Override
    public DoubleBlockTopInteractionMode calculateTopInteractionMode(BlockState state) {
        return DoubleBlockTopInteractionMode.EITHER;
    }

    @Override
    public Tuple<BlockState, BlockState> calculateBlockPair(BlockState state) {
        Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean top = (Boolean)state.m_61143_((Property)FramedProperties.TOP);
        return new Tuple((Object)((BlockState)((BlockState)((Block)FBContent.BLOCK_FRAMED_VERTICAL_HALF_STAIRS.get()).m_49966_().m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)dir)).m_61124_((Property)FramedProperties.TOP, (Comparable)Boolean.valueOf(top))), (Object)((BlockState)((BlockState)((Block)FBContent.BLOCK_FRAMED_SLAB_CORNER.get()).m_49966_().m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)dir.m_122424_())).m_61124_((Property)FramedProperties.TOP, (Comparable)Boolean.valueOf(top))));
    }

    @Override
    public SolidityCheck calculateSolidityCheck(BlockState state, Direction side) {
        boolean top = (Boolean)state.m_61143_((Property)FramedProperties.TOP);
        if (!top && side == Direction.DOWN || top && side == Direction.UP) {
            return SolidityCheck.BOTH;
        }
        return SolidityCheck.NONE;
    }

    @Override
    public CamoGetter calculateCamoGetter(BlockState state, Direction side, @Nullable Direction edge) {
        Direction dirTwo;
        Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean top = (Boolean)state.m_61143_((Property)FramedProperties.TOP);
        Direction direction = dirTwo = top ? Direction.UP : Direction.DOWN;
        if (edge == dirTwo && (side == dir || side == dir.m_122428_())) {
            return CamoGetter.FIRST;
        }
        if (side == dirTwo && (edge == dir || edge == dir.m_122428_())) {
            return CamoGetter.FIRST;
        }
        return CamoGetter.NONE;
    }

    public static BlockState itemModelSource() {
        return (BlockState)((Block)FBContent.BLOCK_FRAMED_VERTICAL_DOUBLE_HALF_STAIRS.get()).m_49966_().m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)Direction.SOUTH);
    }

    public static ShapeProvider generateShapes(ImmutableList<BlockState> states) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (BlockState state : states) {
            builder.put((Object)state, (Object)CommonShapes.SLAB.get((Boolean)state.m_61143_((Property)FramedProperties.TOP)));
        }
        return ShapeProvider.of((Map<BlockState, VoxelShape>)builder.build());
    }
}

