/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.shapes.slopepanelcorner;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.VoxelShape;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.shapes.ShapeCache;
import xfacthd.framedblocks.api.shapes.ShapeProvider;
import xfacthd.framedblocks.api.shapes.ShapeUtils;
import xfacthd.framedblocks.common.block.slopepanel.SlopePanelShape;
import xfacthd.framedblocks.common.data.CornerSlopePanelShape;
import xfacthd.framedblocks.common.data.shapes.SplitShapeGenerator;
import xfacthd.framedblocks.common.data.shapes.slopepanel.SlopePanelShapes;

public final class CornerSlopePanelShapes
implements SplitShapeGenerator {
    public static final CornerSlopePanelShapes SMALL_OUTER = new CornerSlopePanelShapes(CornerSlopePanelShape.SMALL_BOTTOM, CornerSlopePanelShape.SMALL_TOP, Direction.NORTH);
    public static final CornerSlopePanelShapes LARGE_OUTER = new CornerSlopePanelShapes(CornerSlopePanelShape.LARGE_BOTTOM, CornerSlopePanelShape.LARGE_TOP, Direction.NORTH);
    public static final CornerSlopePanelShapes SMALL_INNER = new CornerSlopePanelShapes(CornerSlopePanelShape.SMALL_INNER_BOTTOM, CornerSlopePanelShape.SMALL_INNER_TOP, Direction.SOUTH);
    public static final CornerSlopePanelShapes LARGE_INNER = new CornerSlopePanelShapes(CornerSlopePanelShape.LARGE_INNER_BOTTOM, CornerSlopePanelShape.LARGE_INNER_TOP, Direction.SOUTH);
    public static final ShapeCache<CornerSlopePanelShape> SHAPES = CornerSlopePanelShapes.makeCache(SlopePanelShapes.SHAPES);
    public static final ShapeCache<CornerSlopePanelShape> OCCLUSION_SHAPES = CornerSlopePanelShapes.makeCache(SlopePanelShapes.OCCLUSION_SHAPES);
    private final CornerSlopePanelShape bottomShape;
    private final CornerSlopePanelShape topShape;
    private final Direction srcDir;

    private CornerSlopePanelShapes(CornerSlopePanelShape bottomShape, CornerSlopePanelShape topShape, Direction srcDir) {
        this.bottomShape = bottomShape;
        this.topShape = topShape;
        this.srcDir = srcDir;
    }

    @Override
    public ShapeProvider generate(ImmutableList<BlockState> states) {
        return this.generate(states, SHAPES);
    }

    @Override
    public ShapeProvider generateOcclusionShapes(ImmutableList<BlockState> states) {
        return this.generate(states, OCCLUSION_SHAPES);
    }

    private ShapeProvider generate(ImmutableList<BlockState> states, ShapeCache<CornerSlopePanelShape> cache) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        VoxelShape[] shapes = ShapeUtils.makeHorizontalRotationsWithFlag(cache.get(this.bottomShape), cache.get(this.topShape), this.srcDir);
        for (BlockState state : states) {
            Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
            boolean top = (Boolean)state.m_61143_((Property)FramedProperties.TOP);
            builder.put((Object)state, (Object)shapes[dir.m_122416_() + (top ? 4 : 0)]);
        }
        return ShapeProvider.of((Map<BlockState, VoxelShape>)builder.build());
    }

    private static ShapeCache<CornerSlopePanelShape> makeCache(ShapeCache<SlopePanelShape> cache) {
        return ShapeCache.createEnum(CornerSlopePanelShape.class, map -> {
            VoxelShape panelShapeBottom = cache.get(SlopePanelShape.UP_BACK);
            map.put(CornerSlopePanelShape.SMALL_BOTTOM, ShapeUtils.andUnoptimized(panelShapeBottom, ShapeUtils.rotateShapeUnoptimized(Direction.NORTH, Direction.WEST, panelShapeBottom)));
            VoxelShape panelShapeTop = cache.get(SlopePanelShape.DOWN_BACK);
            map.put(CornerSlopePanelShape.SMALL_TOP, ShapeUtils.andUnoptimized(panelShapeTop, ShapeUtils.rotateShapeUnoptimized(Direction.NORTH, Direction.WEST, panelShapeTop)));
            VoxelShape panelShapeBot = cache.get(SlopePanelShape.UP_FRONT);
            VoxelShape panelShapeBotRot = ShapeUtils.rotateShapeUnoptimized(Direction.NORTH, Direction.WEST, panelShapeBot);
            map.put(CornerSlopePanelShape.LARGE_BOTTOM, ShapeUtils.orUnoptimized(ShapeUtils.andUnoptimized(panelShapeBot, panelShapeBotRot), ShapeUtils.orUnoptimized(ShapeUtils.andUnoptimized(panelShapeBot, Block.m_49796_((double)0.0, (double)0.0, (double)8.0, (double)8.0, (double)16.0, (double)16.0)), ShapeUtils.andUnoptimized(panelShapeBotRot, Block.m_49796_((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0)))));
            panelShapeTop = cache.get(SlopePanelShape.DOWN_FRONT);
            VoxelShape panelShapeTopRot = ShapeUtils.rotateShapeUnoptimized(Direction.NORTH, Direction.WEST, panelShapeTop);
            map.put(CornerSlopePanelShape.LARGE_TOP, ShapeUtils.orUnoptimized(ShapeUtils.andUnoptimized(panelShapeTop, panelShapeTopRot), ShapeUtils.orUnoptimized(ShapeUtils.andUnoptimized(panelShapeTop, Block.m_49796_((double)0.0, (double)0.0, (double)8.0, (double)8.0, (double)16.0, (double)16.0)), ShapeUtils.andUnoptimized(panelShapeTopRot, Block.m_49796_((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0)))));
            panelShapeBottom = cache.get(SlopePanelShape.UP_FRONT);
            map.put(CornerSlopePanelShape.SMALL_INNER_BOTTOM, ShapeUtils.andUnoptimized(Block.m_49796_((double)8.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0), ShapeUtils.orUnoptimized(panelShapeBottom, ShapeUtils.rotateShapeUnoptimized(Direction.NORTH, Direction.WEST, panelShapeBottom))));
            panelShapeTop = cache.get(SlopePanelShape.DOWN_FRONT);
            map.put(CornerSlopePanelShape.SMALL_INNER_TOP, ShapeUtils.andUnoptimized(Block.m_49796_((double)8.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0), ShapeUtils.orUnoptimized(panelShapeTop, ShapeUtils.rotateShapeUnoptimized(Direction.NORTH, Direction.WEST, panelShapeTop))));
            panelShapeBottom = cache.get(SlopePanelShape.UP_BACK);
            map.put(CornerSlopePanelShape.LARGE_INNER_BOTTOM, ShapeUtils.orUnoptimized(panelShapeBottom, ShapeUtils.rotateShapeUnoptimized(Direction.NORTH, Direction.WEST, panelShapeBottom)));
            panelShapeTop = cache.get(SlopePanelShape.DOWN_BACK);
            map.put(CornerSlopePanelShape.LARGE_INNER_TOP, ShapeUtils.orUnoptimized(panelShapeTop, ShapeUtils.rotateShapeUnoptimized(Direction.NORTH, Direction.WEST, panelShapeTop)));
        });
    }
}

