/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.util;

import java.lang.invoke.MethodHandle;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.core.Direction;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.FBContent;

public final class FramedUtils {
    private static final MethodHandle MH_STATE_DEF_BUILDER_GET_PROPERTIES = Utils.unreflectField(StateDefinition.Builder.class, "f_61096_");
    private static final Lazy<Set<Item>> RAIL_ITEMS = Lazy.concurrentOf(() -> {
        Set items = Collections.newSetFromMap(new IdentityHashMap());
        items.addAll(Set.of(Items.f_41964_, Items.f_41860_, Items.f_41861_, Items.f_42161_, ((Block)FBContent.BLOCK_FRAMED_FANCY_RAIL.get()).m_5456_(), ((Block)FBContent.BLOCK_FRAMED_FANCY_POWERED_RAIL.get()).m_5456_(), ((Block)FBContent.BLOCK_FRAMED_FANCY_DETECTOR_RAIL.get()).m_5456_(), ((Block)FBContent.BLOCK_FRAMED_FANCY_ACTIVATOR_RAIL.get()).m_5456_()));
        return items;
    });
    private static final Lazy<Map<Item, Block>> RAIL_SLOPE_BLOCKS = Lazy.concurrentOf(() -> new IdentityHashMap<Item, Block>(Map.of(Items.f_41964_, (Block)FBContent.BLOCK_FRAMED_RAIL_SLOPE.get(), Items.f_41860_, (Block)FBContent.BLOCK_FRAMED_POWERED_RAIL_SLOPE.get(), Items.f_41861_, (Block)FBContent.BLOCK_FRAMED_DETECTOR_RAIL_SLOPE.get(), Items.f_42161_, (Block)FBContent.BLOCK_FRAMED_ACTIVATOR_RAIL_SLOPE.get(), ((Block)FBContent.BLOCK_FRAMED_FANCY_RAIL.get()).m_5456_(), (Block)FBContent.BLOCK_FRAMED_FANCY_RAIL_SLOPE.get(), ((Block)FBContent.BLOCK_FRAMED_FANCY_POWERED_RAIL.get()).m_5456_(), (Block)FBContent.BLOCK_FRAMED_FANCY_POWERED_RAIL_SLOPE.get(), ((Block)FBContent.BLOCK_FRAMED_FANCY_DETECTOR_RAIL.get()).m_5456_(), (Block)FBContent.BLOCK_FRAMED_FANCY_DETECTOR_RAIL_SLOPE.get(), ((Block)FBContent.BLOCK_FRAMED_FANCY_ACTIVATOR_RAIL.get()).m_5456_(), (Block)FBContent.BLOCK_FRAMED_FANCY_ACTIVATOR_RAIL_SLOPE.get())));

    public static boolean isRailItem(Item item) {
        return ((Set)RAIL_ITEMS.get()).contains(item);
    }

    public static Block getRailSlopeBlock(Item item) {
        Block railSlope = (Block)((Map)RAIL_SLOPE_BLOCKS.get()).get(item);
        if (railSlope == null) {
            throw new IllegalStateException("Invalid rail item: " + item);
        }
        return railSlope;
    }

    public static RailShape getAscendingRailShapeFromDirection(Direction dir) {
        return switch (dir) {
            case Direction.NORTH -> RailShape.ASCENDING_NORTH;
            case Direction.EAST -> RailShape.ASCENDING_EAST;
            case Direction.SOUTH -> RailShape.ASCENDING_SOUTH;
            case Direction.WEST -> RailShape.ASCENDING_WEST;
            default -> throw new IllegalArgumentException("Invalid facing " + dir);
        };
    }

    public static Direction getDirectionFromAscendingRailShape(RailShape shape) {
        return switch (shape) {
            case RailShape.ASCENDING_NORTH -> Direction.NORTH;
            case RailShape.ASCENDING_EAST -> Direction.EAST;
            case RailShape.ASCENDING_SOUTH -> Direction.SOUTH;
            case RailShape.ASCENDING_WEST -> Direction.WEST;
            default -> throw new IllegalArgumentException("Invalid shape " + shape);
        };
    }

    public static void enqueueImmediateTask(LevelAccessor level, Runnable task, boolean allowClient) {
        if (level.m_5776_() && allowClient) {
            task.run();
        } else {
            FramedUtils.enqueueTask(level, task, 0);
        }
    }

    public static void enqueueTask(LevelAccessor level, Runnable task, int delay) {
        if (!(level instanceof ServerLevel)) {
            throw new IllegalArgumentException("Utils#enqueueTask() called with a non-ServerWorld");
        }
        ServerLevel slevel = (ServerLevel)level;
        MinecraftServer server = slevel.m_7654_();
        server.m_6937_((Runnable)new TickTask(server.m_129921_() + delay, task));
    }

    public static void addPlayerInvSlots(Consumer<Slot> slotConsumer, Inventory playerInv, int x, int y) {
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                slotConsumer.accept(new Slot((Container)playerInv, col + row * 9 + 9, x + col * 18, y));
            }
            y += 18;
        }
        for (int col = 0; col < 9; ++col) {
            slotConsumer.accept(new Slot((Container)playerInv, col, x + col * 18, y + 4));
        }
    }

    public static void removeProperty(StateDefinition.Builder<Block, BlockState> builder, Property<?> property) {
        try {
            Map properties = MH_STATE_DEF_BUILDER_GET_PROPERTIES.invoke(builder);
            properties.remove(property.m_61708_());
        }
        catch (Throwable e) {
            throw new RuntimeException("Failed to remove property from state builder", e);
        }
    }

    public static IItemHandlerModifiable makeMenuItemHandler(IItemHandlerModifiable handler, Level level) {
        if (level.m_5776_()) {
            handler = new ItemStackHandler(handler.getSlots());
        }
        return handler;
    }

    private FramedUtils() {
    }
}

