/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.util;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;
import xfacthd.framedblocks.api.util.Utils;

public final class ServerConfig {
    public static final ForgeConfigSpec SPEC;
    public static final ServerConfig INSTANCE;
    private static final String KEY_ALLOW_BLOCK_ENTITIES = "allowBlockEntities";
    private static final String KEY_ENABLE_INTANGIBILITY = "enableIntangibleFeature";
    private static final String KEY_INTANGIBLE_MARKER = "intangibleMarkerItem";
    private static final String KEY_ONE_WAY_WINDOW_OWNABLE = "oneWayWindowOwnable";
    private static final String KEY_CONSUME_CAMO_ITEM = "consumeCamoItem";
    private static final String KEY_GLOWSTONE_LIGHT_LEVEL = "glowstoneLightLevel";
    public static final String TRANSLATION_ALLOW_BLOCK_ENTITIES;
    public static final String TRANSLATION_ENABLE_INTANGIBILITY;
    public static final String TRANSLATION_INTANGIBLE_MARKER;
    public static final String TRANSLATION_ONE_WAY_WINDOW_OWNABLE;
    public static final String TRANSLATION_CONSUME_CAMO_ITEM;
    public static final String TRANSLATION_GLOWSTONE_LIGHT_LEVEL;
    public static boolean allowBlockEntities;
    public static boolean enableIntangibleFeature;
    public static Item intangibleMarkerItem;
    public static boolean oneWayWindowOwnable;
    public static boolean consumeCamoItem;
    public static int glowstoneLightLevel;
    private final ForgeConfigSpec.BooleanValue allowBlockEntitiesValue;
    private final ForgeConfigSpec.BooleanValue enableIntangibleFeatureValue;
    private final ForgeConfigSpec.ConfigValue<String> intangibleMarkerItemValue;
    private final ForgeConfigSpec.BooleanValue oneWayWindowOwnableValue;
    private final ForgeConfigSpec.BooleanValue consumeCamoItemValue;
    private final ForgeConfigSpec.IntValue glowstoneLightLevelValue;

    public ServerConfig(ForgeConfigSpec.Builder builder) {
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)this);
        builder.push("general");
        this.allowBlockEntitiesValue = builder.comment("Whether blocks with block entities can be placed in framed blocks").translation(TRANSLATION_ALLOW_BLOCK_ENTITIES).define(KEY_ALLOW_BLOCK_ENTITIES, false);
        this.enableIntangibleFeatureValue = builder.comment("Enables the intangbility feature. Disabling this also prevents moving through blocks that are already marked as intangible").translation(TRANSLATION_ENABLE_INTANGIBILITY).define(KEY_ENABLE_INTANGIBILITY, false);
        this.intangibleMarkerItemValue = builder.comment("The item to use for making Framed Blocks intangible. The value must be a valid item registry name").translation(TRANSLATION_INTANGIBLE_MARKER).define(KEY_INTANGIBLE_MARKER, (Object)ForgeRegistries.ITEMS.getKey((Object)Items.f_42714_).toString(), ServerConfig::validateItemName);
        this.oneWayWindowOwnableValue = builder.comment("If true, only the player who placed the Framed One-Way Window can modify the window direction").translation(TRANSLATION_ONE_WAY_WINDOW_OWNABLE).define(KEY_ONE_WAY_WINDOW_OWNABLE, true);
        this.consumeCamoItemValue = builder.comment("If true, applying a camo will consume the item and removing the camo will drop it again").translation(TRANSLATION_CONSUME_CAMO_ITEM).define(KEY_CONSUME_CAMO_ITEM, true);
        this.glowstoneLightLevelValue = builder.comment("The light level to emit when glowstone dust is applied to a framed block").translation(TRANSLATION_GLOWSTONE_LIGHT_LEVEL).defineInRange(KEY_GLOWSTONE_LIGHT_LEVEL, 15, 0, 15);
        builder.pop();
    }

    private static boolean validateItemName(Object obj) {
        String name;
        ResourceLocation key;
        if (obj instanceof String && ForgeRegistries.ITEMS.containsKey(key = new ResourceLocation(name = (String)obj))) {
            return ForgeRegistries.ITEMS.getValue(key) != Items.f_41852_;
        }
        return false;
    }

    private static String translate(String key) {
        return Utils.translateConfig("server", key);
    }

    @SubscribeEvent
    public void onConfigReloaded(ModConfigEvent event) {
        if (event.getConfig().getType() == ModConfig.Type.SERVER && event.getConfig().getSpec() == SPEC) {
            allowBlockEntities = (Boolean)this.allowBlockEntitiesValue.get();
            enableIntangibleFeature = (Boolean)this.enableIntangibleFeatureValue.get();
            intangibleMarkerItem = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation((String)this.intangibleMarkerItemValue.get()));
            oneWayWindowOwnable = (Boolean)this.oneWayWindowOwnableValue.get();
            consumeCamoItem = (Boolean)this.consumeCamoItemValue.get();
            glowstoneLightLevel = (Integer)this.glowstoneLightLevelValue.get();
        }
    }

    static {
        TRANSLATION_ALLOW_BLOCK_ENTITIES = ServerConfig.translate(KEY_ALLOW_BLOCK_ENTITIES);
        TRANSLATION_ENABLE_INTANGIBILITY = ServerConfig.translate(KEY_ENABLE_INTANGIBILITY);
        TRANSLATION_INTANGIBLE_MARKER = ServerConfig.translate(KEY_INTANGIBLE_MARKER);
        TRANSLATION_ONE_WAY_WINDOW_OWNABLE = ServerConfig.translate(KEY_ONE_WAY_WINDOW_OWNABLE);
        TRANSLATION_CONSUME_CAMO_ITEM = ServerConfig.translate(KEY_CONSUME_CAMO_ITEM);
        TRANSLATION_GLOWSTONE_LIGHT_LEVEL = ServerConfig.translate(KEY_GLOWSTONE_LIGHT_LEVEL);
        Pair configSpecPair = new ForgeConfigSpec.Builder().configure(ServerConfig::new);
        SPEC = (ForgeConfigSpec)configSpecPair.getRight();
        INSTANCE = (ServerConfig)configSpecPair.getLeft();
    }
}

