/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.common.backpack.loader;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mrcrayfish.backpacked.Constants;
import com.mrcrayfish.backpacked.common.backpack.BackpackManager;
import com.mrcrayfish.backpacked.common.backpack.ModelMeta;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import org.slf4j.Logger;

public class ModelMetaLoader
extends SimplePreparableReloadListener<Map<ResourceLocation, ModelMeta>> {
    private static final String DIRECTORY = "backpacked";
    private static final String EXTENSION = ".backpack";
    private static final FileToIdConverter CONVERTER = new FileToIdConverter("backpacked", ".backpack");
    private static final Gson GSON = new GsonBuilder().create();

    protected Map<ResourceLocation, ModelMeta> prepare(ResourceManager manager, ProfilerFiller filler) {
        HashMap<ResourceLocation, ModelMeta> map = new HashMap<ResourceLocation, ModelMeta>();
        CONVERTER.m_247457_(manager).forEach((location, resource) -> {
            try (BufferedReader reader = resource.m_215508_();){
                JsonElement element = (JsonElement)GsonHelper.m_13776_((Gson)GSON, (Reader)reader, JsonElement.class);
                DataResult result = ModelMeta.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)element);
                if (result.error().isPresent()) {
                    Constants.LOG.error("Failed to parse backpack meta: %s".formatted(location));
                    Constants.LOG.error(((DataResult.PartialResult)result.error().get()).message());
                } else {
                    String raw = location.m_135815_();
                    String path = location.m_135815_().substring("backpacked/".length(), raw.length() - EXTENSION.length());
                    ResourceLocation key = new ResourceLocation(location.m_135827_(), path);
                    map.put(key, (ModelMeta)result.getOrThrow(false, arg_0 -> ((Logger)Constants.LOG).error(arg_0)));
                }
            }
            catch (IOException e) {
                Constants.LOG.error("Failed to load backpack meta: %s".formatted(location), (Throwable)e);
            }
        });
        return map;
    }

    protected void apply(Map<ResourceLocation, ModelMeta> map, ResourceManager manager, ProfilerFiller filler) {
        BackpackManager.instance().updateModelMeta(map);
    }
}

