/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.item;

import com.jaquadro.minecraft.storagedrawers.block.tile.BlockEntityController;
import com.jaquadro.minecraft.storagedrawers.config.CommonConfig;
import com.jaquadro.minecraft.storagedrawers.core.ModItems;
import com.jaquadro.minecraft.storagedrawers.item.ItemUpgrade;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemUpgradeRemote
extends ItemUpgrade {
    private static final int remoteGroupId = ItemUpgrade.getNextGroupId();
    private final boolean groupUpgrade;
    private final boolean bound;

    public ItemUpgradeRemote(boolean groupUpgrade, boolean bound, Item.Properties properties) {
        super(properties, remoteGroupId);
        this.groupUpgrade = groupUpgrade;
        this.bound = bound;
    }

    @Override
    public boolean isEnabled() {
        if (this.groupUpgrade) {
            return (Boolean)CommonConfig.UPGRADES.enableRemoteGroupUpgrade.get();
        }
        return (Boolean)CommonConfig.UPGRADES.enableRemoteUpgrade.get();
    }

    @Override
    public void m_7373_(@NotNull ItemStack itemStack, @Nullable Level world, List<Component> list, TooltipFlag advanced) {
        super.m_7373_(itemStack, world, list, advanced);
        BlockPos pos = ItemUpgradeRemote.getBoundPosition(itemStack);
        if (pos != null) {
            list.add((Component)Component.m_237110_((String)(this.m_5524_() + ".bound"), (Object[])new Object[]{pos.m_123341_(), pos.m_123342_(), pos.m_123343_()}).m_130940_(ChatFormatting.YELLOW));
        } else {
            list.add((Component)Component.m_237115_((String)(this.m_5524_() + ".bound")).m_130940_(ChatFormatting.RED));
        }
    }

    public static BlockPos getBoundPosition(ItemStack itemStack) {
        if (itemStack == null) {
            return null;
        }
        CompoundTag tag = itemStack.m_41783_();
        if (tag == null) {
            return null;
        }
        CompoundTag posTag = tag.m_128469_("bound_controller");
        if (posTag.m_128456_()) {
            return null;
        }
        int x = posTag.m_128451_("x");
        int y = posTag.m_128451_("y");
        int z = posTag.m_128451_("z");
        return new BlockPos(x, y, z);
    }

    public static ItemStack setBoundController(ItemStack itemStack, BlockEntityController controller) {
        if (itemStack == null || controller == null) {
            return itemStack;
        }
        Item item = itemStack.m_41720_();
        if (item instanceof ItemUpgradeRemote) {
            ItemUpgradeRemote item2 = (ItemUpgradeRemote)item;
            CompoundTag posTag = new CompoundTag();
            posTag.m_128405_("x", controller.m_58899_().m_123341_());
            posTag.m_128405_("y", controller.m_58899_().m_123342_());
            posTag.m_128405_("z", controller.m_58899_().m_123343_());
            CompoundTag tag = itemStack.m_41784_();
            tag.m_128365_("bound_controller", (Tag)posTag);
            ItemStack newStack = new ItemStack(item2.isGroupUpgrade() ? (ItemLike)ModItems.REMOTE_GROUP_UPGRADE_BOUND.get() : (ItemLike)ModItems.REMOTE_UPGRADE_BOUND.get(), itemStack.m_41613_());
            newStack.m_41751_(tag);
            return newStack;
        }
        return itemStack;
    }

    public static ItemStack setUnbound(ItemStack itemStack) {
        Item item;
        if (itemStack != null && (item = itemStack.m_41720_()) instanceof ItemUpgradeRemote) {
            ItemUpgradeRemote item2 = (ItemUpgradeRemote)item;
            ItemStack newStack = new ItemStack(item2.isGroupUpgrade() ? (ItemLike)ModItems.REMOTE_GROUP_UPGRADE.get() : (ItemLike)ModItems.REMOTE_UPGRADE.get(), itemStack.m_41613_());
            CompoundTag tag = itemStack.m_41784_();
            if (tag.m_128441_("bound_controller")) {
                tag.m_128473_("bound_controller");
            }
            newStack.m_41751_(tag);
            return newStack;
        }
        return itemStack;
    }

    public static ItemStack copyControllerBinding(ItemStack refStack, ItemStack targetStack) {
        if (refStack == null || targetStack == null) {
            return targetStack;
        }
        Item item = refStack.m_41720_();
        if (item instanceof ItemUpgradeRemote) {
            ItemUpgradeRemote refItem = (ItemUpgradeRemote)item;
            item = targetStack.m_41720_();
            if (item instanceof ItemUpgradeRemote) {
                ItemUpgradeRemote targetItem = (ItemUpgradeRemote)item;
                Item newItem = targetItem.isGroupUpgrade() ? (refItem.isBound() ? (Item)ModItems.REMOTE_GROUP_UPGRADE_BOUND.get() : (Item)ModItems.REMOTE_GROUP_UPGRADE.get()) : (refItem.isBound() ? (Item)ModItems.REMOTE_UPGRADE_BOUND.get() : (Item)ModItems.REMOTE_UPGRADE.get());
                ItemStack newStack = new ItemStack((ItemLike)newItem, targetStack.m_41613_());
                CompoundTag targetTag = targetStack.m_41784_().m_6426_();
                CompoundTag refTag = refStack.m_41784_();
                if (refTag.m_128441_("bound_controller")) {
                    targetTag.m_128365_("bound_controller", (Tag)refTag.m_128469_("bound_controller"));
                }
                newStack.m_41751_(targetTag);
                return newStack;
            }
        }
        return targetStack;
    }

    public static BlockEntityController getBoundController(ItemStack itemStack, LevelAccessor level) {
        if (level == null) {
            return null;
        }
        BlockPos pos = ItemUpgradeRemote.getBoundPosition(itemStack);
        if (pos == null) {
            return null;
        }
        BlockEntity entity = level.m_7702_(pos);
        if (entity instanceof BlockEntityController) {
            BlockEntityController bec = (BlockEntityController)entity;
            return bec;
        }
        return null;
    }

    public static void validateInventory(Inventory inventory, Level level) {
        if (level == null || inventory == null) {
            return;
        }
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            Item item;
            ItemStack stack = inventory.m_8020_(i);
            if (stack.m_41619_() || !((item = stack.m_41720_()) instanceof ItemUpgradeRemote)) continue;
            ItemUpgradeRemote item2 = (ItemUpgradeRemote)item;
            if (!item2.bound || ItemUpgradeRemote.getBoundController(stack, (LevelAccessor)level) != null) continue;
            inventory.m_6836_(i, ItemUpgradeRemote.setUnbound(stack));
        }
    }

    public boolean isGroupUpgrade() {
        return this.groupUpgrade;
    }

    public boolean isBound() {
        return this.bound;
    }
}

